////////////////////////////////////////////////////////////////////////////////
// WhistleWindow.cpp
// -----------------
// Implements the WhistleWindow class.
//
// Copyright 1999, Be Incorporated. All Rights Reserved.
// This file may be used under the terms of the Be Sample Code License.

#include "WhistleWindow.h"

WhistleWindow::WhistleWindow(BHandler *handler) : BWindow(BRect(0,0,1,1), 
									"Whistle  window",
									B_BORDERED_WINDOW,
									0,
									B_ALL_WORKSPACES)
{
	whistle_handler = handler;
	dummy_view = new BView(BRect(0,0,1,1), "Whistle dummy view",0,0);
	dummy_view->SetEventMask(B_POINTER_EVENTS | B_KEYBOARD_EVENTS,
							B_NO_POINTER_HISTORY);
	AddChild(dummy_view);
}


void WhistleWindow::DispatchMessage(BMessage *msg, BHandler *handler)
{
	switch (msg->what) {
	case B_KEY_DOWN:
	case B_MOUSE_DOWN:
	case B_MOUSE_UP:
	case B_MOUSE_MOVED:
	case B_WORKSPACE_ACTIVATED:
		whistle_handler->MessageReceived(msg);
		break;
	default:
		BWindow::DispatchMessage(msg, handler);
		break;
	}
}

