////////////////////////////////////////////////////////////////////////////////
// WhistleApp.cpp
// --------------
// Implements the Whistle application class.
//
// Copyright 1999, Be Incorporated. All Rights Reserved.
// This file may be used under the terms of the Be Sample Code License.

#include "WhistleApp.h"

	
WhistleApp::WhistleApp() :
	BApplication("application/x-lbj-whistle") 
{
	whistler = new Whistler();
	whistler->SetMouseVol(.25);
	whistler->SetKeyboardVol(.75);
	whistler->SetButtonsVol(.8);
	whistle_window = new WhistleWindow(whistler);
	whistle_window->MoveTo(-10,-10);
	whistle_window->Show();
	whistle_window->Hide();
	whistle_window->MoveTo(0,0);
	show_control = true;

}

WhistleApp::~WhistleApp()
{
	delete whistler;
};


void WhistleApp::ReadyToRun()
{
	if (show_control) {
		cwindow = new ControlWindow(BPoint(100,100));
		cwindow->Show();
	}
	whistler->Go();

}

#include "PigTail.h"
void WhistleApp::MessageReceived(BMessage *msg)
{
	int32 index;
	float value;

	switch (msg->what) {
	case PIG_MSG:
		msg->FindFloat((const char *)"value", &value);
		msg->FindInt32((const char *)"index", &index);
		switch (index) {
		case 0:
			whistler->SetKeyboardVol(value);
			break;
		case 1:
			whistler->SetMouseVol(value);
			break;
		case 2:
			whistler->SetButtonsVol(value);
			break;
		}
		break;
		
	default:
		BApplication::MessageReceived(msg);
		break;
	}
}	
#include <stdio.h>

#define KEYBOARD 0x1
#define MOUSE 0x2
#define BUTTONS 0x4
#define MASTER (KEYBOARD|MOUSE|BUTTONS)

void WhistleApp::ArgvReceived(int32 argc, char **argv)
{
	int32 ktr, ktr1;
	float value;
	int32 which=0;
	
	for (ktr = 1; ktr < argc; ktr++) {
		if (argv[ktr][0] == '-') {
			which = 0;
			for (ktr1 = 1; argv[ktr][ktr1] != 0; ktr1++) {
				switch (argv[ktr][ktr1]) {
				case 'k':
				case 'K':
					which |= KEYBOARD;
					break;
				case 'm':
				case 'M':
					which |= MOUSE;
					break;
				case 'b':
				case 'B':
					which |= BUTTONS;
					break;
				case 'q':
				case 'Q':
					show_control = false;
					break;
				default:
					break;
				}
			}
			continue;
		}
		
		if (sscanf(argv[ktr], "%f", &value) == 1) {
			if (which == 0) {
				which = MASTER;
			}
			if (which & KEYBOARD) 
				whistler->SetKeyboardVol(value);
			if (which & MOUSE) 
				whistler->SetMouseVol(value);
			if (which & BUTTONS) 
				whistler->SetButtonsVol(value);
			which = 0;
		}					
			
	}
}

int main(int32 argc, char **argv)
{
	WhistleApp().Run();
}

