////////////////////////////////////////////////////////////////////////////////
// PigTail.h
// ---------
// Defines the PigTail slider control.
//
// Copyright 1999, Be Incorporated. All Rights Reserved.
// This file may be used under the terms of the Be Sample Code License.

#ifndef PIG_TAIL
#define PIG_TAIL

#include <View.h>
#include <Picture.h>
#include <Bitmap.h>
#include <Shape.h>
#include <Window.h>

#define PIG_TAIL_POINTS 10
#define PIG_MSG 'pigm'
#define PIG_FOCUS_MSG 'pigf'

class PigTail : public BView
{
	public:
	PigTail(BRect frame, int32 index);
	
	void SetBubble(float level, bool inc=false);
	void SetBubble(int32 coord);
	void NewColors(void);
	void NewShape(void);
	virtual void AttachedToWindow();
	virtual void Draw(BRect update);
	
	void KeyDown(const char *bytes, int32 numBytes);
	virtual void MouseDown(BPoint where);
	virtual void MouseUp(BPoint where);
	virtual void MouseMoved(BPoint where,
							uint32 code,
							const BMessage *a_message);
	
	private:

	void update_offscreen();
	void make_shape(BShape *shape);
	void bend_shape(BShape *shape);
	void send_pig_message(void);
	BPicture *picture;
	int32 r,g,b;
	rgb_color guage_hi, guage_lo;
	bool r_up, g_up, b_up;
	int32 height;
	int32 bubble;
	int32 index;
	bool tracking;
	float breaks[11][3];
	BShape *shape;
	bool key_down;
};

#endif /* PIG_TAIL */
