////////////////////////////////////////////////////////////////////////////////
// ControlWindow.h
// ---------------
// Defines the window that contains the Whistle controls,
// and the controls' parent view.
//
// Copyright 1999, Be Incorporated. All Rights Reserved.
// This file may be used under the terms of the Be Sample Code License.

#ifndef CONTROL_WINDOW
#define CONTROL_WINDOW

#include "PigTail.h"
#include <Window.h>
#include <View.h>
#include <OS.h>

class ControlView : public BView
{
	public:
	ControlView(BRect frame);
	~ControlView();
	virtual void Draw(BRect update);
	virtual void AttachedToWindow(void);
	void SwitchFocus(bool up);
	virtual void KeyDown(const char *bytes, int32 numBytes);
	
	private:
	void focus_animation();
	static int32 _focus(void *arg);
	thread_id focus_thread;
	
	PigTail *pigtails[3];
	PigTail *prevFocus;
	BRect pigrects[3];
	BPoint focusDot;
	bool keep_going;
};
	
class ControlWindow : public BWindow
{
	public:
	ControlWindow(BPoint origin);
	~ControlWindow();
	bool QuitRequested(void);
	virtual void MessageReceived(BMessage *msg);
	private:
	ControlView *view;
};
 
#endif /* CONTROL_WINDOW */
