////////////////////////////////////////////////////////////////////////////////
// ControlWindow.cpp
// -----------------
// Implements the ControlWindow and ControlView classes.
//
// Copyright 1999, Be Incorporated. All Rights Reserved.
// This file may be used under the terms of the Be Sample Code License.

#include "ControlWindow.h"
#include "Application.h"
#define PIG_WIDTH 30
#define PIG_HEIGHT 230
#define TEXT_HEIGHT 17
#define MARGIN	10
#define T_MARGIN 4
#include <stdio.h>
#include <stdlib.h>

ControlWindow::ControlWindow(BPoint origin) :
	BWindow(BRect(origin.x, origin.y, 
		origin.x+PIG_WIDTH*3+MARGIN*4,
		origin.y+PIG_HEIGHT+TEXT_HEIGHT+MARGIN*2+T_MARGIN),
		"Whistle",
		B_TITLED_WINDOW, B_NOT_RESIZABLE|B_WILL_ACCEPT_FIRST_CLICK)
{
	view = new ControlView(Bounds());
	AddChild(view);
}

ControlWindow::~ControlWindow()
{}

bool ControlWindow::QuitRequested(void)
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return true;
}

void ControlWindow::MessageReceived(BMessage *msg)
{
	bool up;
	switch (msg->what) {
	case PIG_FOCUS_MSG:
		msg->FindBool("up", &up);
		view->SwitchFocus(up);
		break;
	default:
		BWindow::MessageReceived(msg);
		break;
	}
}

int32 ControlView::_focus(void *arg)
{
	((ControlView *)arg)->focus_animation();
	return B_OK;
}

ControlView::ControlView(BRect frame) :
	BView(frame, "Whistle Control View", 0, B_WILL_DRAW)
{
	BRect pig(MARGIN, MARGIN, MARGIN+PIG_WIDTH, MARGIN+PIG_HEIGHT);
	pigrects[0] = pig.InsetByCopy(-4.0,-4.0);
	pigtails[0] = new PigTail(pig, 0);
	pigtails[0]->SetBubble((float).75);
	AddChild(pigtails[0]);
	
	pig.OffsetBy(BPoint((MARGIN+PIG_WIDTH),0));
	pigrects[1] = pig.InsetByCopy(-4.0,-4.0);
	pigtails[1] = new PigTail(pig, 1);
	pigtails[1]->SetBubble((float).25);
	AddChild(pigtails[1]);

	pig.OffsetBy(BPoint((MARGIN+PIG_WIDTH),0));
	pigrects[2] = pig.InsetByCopy(-4.0,-4.0);
	pigtails[2] = new PigTail(pig, 2);
	pigtails[2]->SetBubble((float).8);
	AddChild(pigtails[2]);
	
	SetViewColor(B_TRANSPARENT_COLOR);
	SetHighColor(200,200,200);
	SetLowColor(0,0,0);
	SetFontSize(18);
	
}

void ControlView::AttachedToWindow()
{
	prevFocus = (PigTail *)NULL;
	focusDot.x = -1;
	focusDot.y = -1;
	focus_thread = spawn_thread(_focus, "Whistle Focus", B_NORMAL_PRIORITY, (void *)this);
	resume_thread(focus_thread);
	MakeFocus(true);
}

ControlView::~ControlView()
{
	keep_going = false;
	while (find_thread("Whistle Focus") == B_OK)
		snooze(10000);
	
}

#define FOCUS_RADIUS 2

#define LT_RT 0
#define RT_RB 1
#define RB_LB 2
#define LB_LT 3
#define INC 5

void ControlView::focus_animation()
{

	PigTail *inFocus;
	BRect focusRect;
	static int32 stage = LT_RT;
	int32 ktr;
	keep_going = true;
	
	while (keep_going) {
		snooze(10000);
		if (! LockLooper()) break;
		for (ktr = 0; ktr < 3; ktr++) {
			if (pigtails[ktr]->IsFocus()) {
				inFocus = pigtails[ktr];
				focusRect = pigrects[ktr];
				break;
			}
			if (ktr == 2)
				continue;
		}
	
		if (focusDot.x != -1) 
			FillEllipse(focusDot, FOCUS_RADIUS, FOCUS_RADIUS, B_SOLID_LOW);

		if (focusDot.x == -1 || prevFocus != inFocus) {
			focusDot = focusRect.LeftTop();
			focusDot.x += 1;
			focusDot.y += 1;
			stage = LT_RT;
		}
		switch (stage) {
		case LT_RT:
			focusDot.x += INC;
			if (!focusRect.Contains(focusDot)) {
				focusDot.x -= INC;
				focusDot.y += INC;
				stage = RT_RB;
			}
			break;
		case RT_RB:
			focusDot.y += INC;
			if (!focusRect.Contains(focusDot)) {
				focusDot.y -= INC;
				focusDot.x -= INC;
				stage = RB_LB;
			}
			break;
		case RB_LB:
			focusDot.x -= INC;
			if (!focusRect.Contains(focusDot)) {
				focusDot.x += INC;
				focusDot.y -= INC;
				stage = LB_LT;
			}
			break;
		case LB_LT:
			focusDot.y -= INC;
			if (!focusRect.Contains(focusDot)) {
				focusDot.y += INC;
				focusDot.x -= INC;
				stage = LT_RT;
			}
			break;
		}
		SetLowColor(255,rand()%100,rand()%100);
		FillEllipse(focusDot, FOCUS_RADIUS, FOCUS_RADIUS, B_SOLID_LOW);
		SetLowColor(0,0,0);
		prevFocus = inFocus;
		if (!keep_going) 
			break;
		Window()->Sync();
		UnlockLooper();
	}
}

void ControlView::Draw(BRect update)
{
	FillRect(update, B_SOLID_LOW);
	MovePenTo(pigtails[0]->Frame().LeftBottom() + 
		BPoint(10, T_MARGIN+TEXT_HEIGHT));
	DrawChar('K');

	MovePenTo(pigtails[1]->Frame().LeftBottom() + 
		BPoint(10, T_MARGIN+TEXT_HEIGHT));
	DrawChar('M');

	MovePenTo(pigtails[2]->Frame().LeftBottom() + 
		BPoint(10, T_MARGIN+TEXT_HEIGHT));
	DrawChar('B');
};
	
void ControlView::SwitchFocus(bool up)
{
	int32 ktr;
	for (ktr = 0; ktr < 3; ktr++) {
		if (pigtails[ktr]->IsFocus()) {
			break;
		}
	}

	if (ktr == 3) {
		pigtails[0]->MakeFocus(true);
		return;
	}
	
	if (up) {
		ktr++;
		ktr %= 3;	
	}
	else {
		if (--ktr == -1)
			ktr = 2;
	}
	pigtails[ktr]->MakeFocus(true);
}
	
void ControlView::KeyDown(const char *bytes, int32)
{
	switch (bytes[0]) {
	case B_TAB:
	case B_UP_ARROW:
	case B_DOWN_ARROW:
	case B_LEFT_ARROW:
	case B_RIGHT_ARROW:
		SwitchFocus(true);
		break;
	default:
		break;
	}
}
