#ifndef TICKER_H
#define TICKER_H

#include <OS.h>
#include "thread.h"
#include "timecode.h"

class tick;

const uint32	MAX_CONNECTIONS	= 255;

class ticker : public thread
{
public:
			ticker(	float frequency = 1,
					const char *name="ticker_thread", 
					long aPriority = B_NORMAL_PRIORITY);

			float		Frequency();
			void		SetFrequency(float frequency);

			bigtime_t	Period();
			void		SetPeriod(bigtime_t period);
			
	virtual	status_t	Start();
	virtual	void		Stop();
			bool		IsStopping() const;
	virtual	void		Reset();

			status_t	Connect(port_id toPort);
			void		Disconnect(port_id fromPort);
			bool		IsConnected(port_id toPort) const;
	
			port_id		fConnectionList[MAX_CONNECTIONS];

private:
	virtual	status_t	ThreadMain();	//overridden from thread
			void		OutputTick(	bigtime_t time, 
									uint64 number, 
									bigtime_t period);

			area_id		fAreaID;
			char 		*fAreaAddress;
			int32		fTickIndex;
			size_t		fAreaSize;
			bigtime_t	fPeriod;		//microsecs per tick
			uint32		fFrequency;		//ticks per second (Hz)
			bool		fIsStopping;
			timecode	fTimecode;
};

#endif //TICKER_H