//******************************************************************************
//
//	File:			tick.h
//
//	Description:	tick object interface.
//
//	Written by:	Douglas Wright
//
//	Copyright 1998, Be Incorporated
//
//******************************************************************************

#ifndef _TICK_H
#define _TICK_H

#include "timecode.h"

const int32		AREA_MSG		= 'area';
const int32		TICK_MSG		= 'tick';

/*------------------------------------------------------------*/

class tick {

public:	
	bigtime_t		fTime;
	uint64			fNumber;
	bigtime_t		fPeriod;
	timecode		fTimecode;

	// Operators used for sorting chronologically
	bool		operator<(const tick&) const;
	bool		operator==(const tick&) const;
	bool		operator>(const tick&) const;
	
};

inline bool tick::operator<(const tick& t) const
{ return(fTime < t.fTime); }

inline bool tick::operator==(const tick& t) const
{ return(fTime == t.fTime); }

inline bool tick::operator>(const tick& t) const
{ return(fTime > t.fTime); }

/*------------------------------------------------------------*/

#endif
