//******************************************************************************
//
//	File:			chaser.cpp
//
//	Description:	chaser object class.
//
//	Written by:		Douglas Wright
//
//	Copyright 1998, Be Incorporated
//
//****************************************************************************

#include "chaser.h"
#include "tick.h"

/*------------------------------------------------------------*/

const uint32	MAX_QUEUED_MSGS	= 10;

/*------------------------------------------------------------*/

chaser::chaser(void (*ticked_func)(void *arg, tick *t), 
				void *arg, 
				const char *name="ticker_thread", 
				int32 aPriority = B_NORMAL_PRIORITY)
		:thread(name, aPriority)
{
  	Ticked = ticked_func;
  	fCaller = arg;
  	fIsStopping = false;
  	fAreaAddress = NULL;
  	fAreaID = -1;
  	fPortID = -1;
  	Start();
}

/*------------------------------------------------------------*/

status_t
chaser::Start()
{
	fPortID = create_port(MAX_QUEUED_MSGS, "tickInPort");
	if (fPortID < 0)
	  	return PortID();
	return Run();
}

/*------------------------------------------------------------*/

void
chaser::Stop()
{
	fIsStopping = true;
	long dummy;
	WaitForExit(&dummy);
}

/*------------------------------------------------------------*/

bool 
chaser::IsStopping()
{
	return fIsStopping;
}

/*------------------------------------------------------------*/

port_id		
chaser::PortID() const
{ 
  return fPortID; 
}

/*------------------------------------------------------------*/

status_t
chaser::ThreadMain()
{
	int32 		i;
	tick 		*t;
  	long 		err = 0;

	while(!IsStopping()){
		long msg = 0;
		if (err < 0 && err != B_INTERRUPTED)
	  		break;

		ssize_t msgSize = port_buffer_size(fPortID);
		if (msgSize < 0) {
	  		err = msgSize;
	  		continue;
		}
		
		if (msgSize == sizeof(i)) {
	  		err = read_port(fPortID, &msg, &i, sizeof(i));
	  		if (err < 0){
				continue;
			}	
	  		if (msg == AREA_MSG){
	  			printf("AREA_MSG\n");
	  			printf("area_id = %x\n", i);
  				app_info appinfo; 
   				if ( be_app->GetAppInfo(&appinfo) == B_OK ){
   					area_info areainfo;
   					get_area_info(i, &areainfo);
   					if(appinfo.team != areainfo.team){
   						fAreaID = clone_area("chaser area", 
												&fAreaAddress, 
                     							B_ANY_ADDRESS, 
                  								B_READ_AREA, 
                  								i);
                  	}else{
                  		fAreaID = i;
                  		fAreaAddress = (char *)areainfo.address;
                  	}
                }
      			if (fAreaID < B_OK){
         			printf("Couldn't create clone area\\n"); 
         			return fAreaID; 
         		}
     		}
	  		if (msg == TICK_MSG){
	  			t = (tick *)(fAreaAddress + (sizeof(tick) * i));
  				//printf("tick address = %x\n", t);
				(*Ticked)(fCaller, t);
     		}
		}
  	}
  	return B_OK;
}

/*------------------------------------------------------------*/