//TCWindow.cpp	

#include "TCWin.h"

const uint32 START_MSG = 'strt';
const uint32 STOP_MSG = 'stop';
const uint32 CON_MSG = 'cnct';
const uint32 DIS_MSG = 'dcnt';

//TCWin
TCWin::TCWin(BPoint point)
		:BWindow( BRect(point.x, point.y, point.x+200, point.y+80),
					"TimeCodeTicker",
					B_TITLED_WINDOW,
					B_NOT_RESIZABLE | B_NOT_ZOOMABLE )
{	
	//counter display
	BRect rect(10, 45, 40, 75);
	BStringView *hrs = new BStringView(rect, 
										"hours", 
										"00", 
										B_FOLLOW_LEFT | B_FOLLOW_TOP, 
										B_WILL_DRAW);
	hrs->SetFont(be_bold_font);
	hrs->SetFontSize(24);
	rect.Set(45, 45, 55, 75);
	BStringView *col1 = new BStringView(rect, 
										"colon", 
										":", 
										B_FOLLOW_LEFT | B_FOLLOW_TOP, 
										B_WILL_DRAW);
	col1->SetFont(be_bold_font);
	col1->SetFontSize(24);
	rect.Set(60, 45, 90, 75);
	BStringView *min = new BStringView(rect, 
										"minutes", 
										"00", 
										B_FOLLOW_LEFT | B_FOLLOW_TOP, 
										B_WILL_DRAW);
	min->SetFont(be_bold_font);
	min->SetFontSize(24);
	rect.Set(95, 45, 105, 75);
	BStringView *col2 = new BStringView(rect, 
										"colon", 
										":", 
										B_FOLLOW_LEFT | B_FOLLOW_TOP, 
										B_WILL_DRAW);
	col2->SetFont(be_bold_font);
	col2->SetFontSize(24);
	rect.Set(110, 45, 140, 75);
	BStringView *sec = new BStringView(rect, 
										"seconds", 
										"00", 
										B_FOLLOW_LEFT | B_FOLLOW_TOP, 
										B_WILL_DRAW);
	rect.Set(145, 45, 155, 75);
	sec->SetFont(be_bold_font);
	sec->SetFontSize(24);
	BStringView *col3 = new BStringView(rect, 
										"colon", 
										":", 
										B_FOLLOW_LEFT | B_FOLLOW_TOP, 
										B_WILL_DRAW);
	col3->SetFont(be_bold_font);
	col3->SetFontSize(24);
	rect.Set(160, 45, 190, 75);
	BStringView *frm = new BStringView(rect, 
										"frames", 
										"00", 
										B_FOLLOW_LEFT | B_FOLLOW_TOP, 
										B_WILL_DRAW);
	frm->SetFont(be_bold_font);
	frm->SetFontSize(24);

	AddChild(frm);
	AddChild(col1);
	AddChild(sec);
	AddChild(col2);
	AddChild(min);
	AddChild(col3);
	AddChild(hrs);
	
	//timecode objects
	tcout = new ticker(29.97, "ticker", B_REAL_TIME_PRIORITY);
	tcin = new TCIn();
	tcin->Setup(frm, sec, min, hrs);
	tcout->Connect(tcin->PortID());
	
	//start button
	rect.Set( 5, 5, 95, 35 );
	BMessage *startMsg = new BMessage( START_MSG );
	BButton* startButton = new BButton(rect, 
										"start", 
         								"start", 
         								 startMsg);
	//stop button
	rect.OffsetBy( 100, 0 );
	BMessage *stopMsg = new BMessage( STOP_MSG );
	BButton* stopButton = new BButton(rect, 
										"stop", 
         								"stop", 
         								 stopMsg);
    AddChild(startButton);
    AddChild(stopButton);
}

void 
TCWin::MessageReceived(BMessage *message)
{
	if(message == NULL)
		return;
	switch( message->what ){
		case START_MSG:
			tcin->Reset();
			tcout->Reset();
			tcout->Start();
			break;
		case STOP_MSG:
			tcout->Stop();
		break;
		case CON_MSG:{
			area_id id;
			if(message->FindInt32("port", &id) == B_OK){
				printf("%d\n", id);
				tcout->Connect(id);
				if(!tcout->IsConnected(id)){
					printf("Still not connected!\n");
				}
			}
			break;
		}
		case DIS_MSG:{
			area_id id;
			if(message->FindInt32("port", &id) == B_OK){
				printf("%d\n", id);
				tcout->Disconnect(id);
			}
			break;
		}
		default:
			BWindow::MessageReceived(message);
			break;
	}
}

bool 
TCWin::QuitRequested()
{
	tcout->Stop();
	
	be_app->PostMessage(B_QUIT_REQUESTED);
	return(true);
}