//TCIn.cpp

#include "TCIn.h"
#include "tick.h"
#include "timecode.h"

//************************************************

void 
Ticked(void *arg, tick *t)
{
	TCIn *tcin = (TCIn*)arg;
	char str[3];

	if(t->fTimecode != tcin->fCurrent){
		//account for missed frames here
		printf("missing frames!\n", t->fTimecode);
		tcin->fCurrent = t->fTimecode;
		if(tcin->framesView->Window()->Lock()){
			sprintf(str, "%-0.2u", tcin->fCurrent.second);
			tcin->framesView->SetText(str);
			sprintf(str, "%-0.2u", tcin->fCurrent.second);
			tcin->secondsView->SetText(str);
			sprintf(str, "%-0.2u", tcin->fCurrent.minute);
			tcin->minutesView->SetText(str);
			sprintf(str, "%-0.2u", tcin->fCurrent.hour);
			tcin->hoursView->SetText(str);
			tcin->framesView->Window()->Unlock();
		}
	}
	
	sprintf(str, "%-0.2u", tcin->fCurrent.frame);
	if(tcin->framesView->Window()->Lock()){
		tcin->framesView->SetText(str);
		if(tcin->fCurrent.frame == 0){
			sprintf(str, "%-0.2u", tcin->fCurrent.second);
			tcin->secondsView->SetText(str);
			if(tcin->fCurrent.second == 0){
				sprintf(str, "%-0.2u", tcin->fCurrent.minute);
				tcin->minutesView->SetText(str);
				if(tcin->fCurrent.minute == 0){
					sprintf(str, "%-0.2u", tcin->fCurrent.hour);
					tcin->hoursView->SetText(str);
				}
			}
		}
		tcin->framesView->Window()->Unlock();
	}
	++tcin->fCurrent;
}

//************************************************

TCIn::TCIn()
{
	printf("tcin\n");
	fChaser = new chaser(Ticked, this, "fChaser", B_URGENT_PRIORITY);
}

port_id
TCIn::PortID()
{
	return fChaser->PortID();
}

void 
TCIn::Reset()
{
	printf("tcin::reset\n");
	fCurrent.Set(0,0,0,0);
	if(framesView->Window()->Lock()){
		framesView->SetText("00");
		secondsView->SetText("00");
		minutesView->SetText("00");
		hoursView->SetText("00");
		framesView->Window()->Unlock();
	}
}
	
void 
TCIn::Setup(BStringView *frm, 
			BStringView *sec,
			BStringView *min,
			BStringView *hrs)
{
	printf("tcin::setup\n");
	framesView = frm;
	secondsView = sec;
	minutesView = min;
	hoursView = hrs;
}

