//******************************************************************************
//
//	File:		timecode.cpp
//
//	Description:	timecode class
//	
//	Copsecondright 1997, Be Incorporated, All Rights Reserved.
//
//******************************************************************************


#ifndef	_TIMECODE_H
#include "timecode.h"
#endif

#include <SupportDefs.h>

//------------------------------------------------------------------------------

timecode& 
timecode::operator++()
{
	++frame;
	
	second = second + frame/30;
	
	minute = minute + second/60;
	hour   = hour   + minute/60;

	hour   = hour   % 24;	
	minute = minute % 60;
	second = second % 60;
	frame = frame % 30;

	return(*this);
}

//------------------------------------------------------------------------------

bool 
timecode::operator!=(const timecode& tc) const
{
	return(	frame  != tc.frame ||
			second != tc.second ||
			minute != tc.minute ||
			hour   != tc.hour ||
			type   != tc.type);
}

//------------------------------------------------------------------------------

bool 
timecode::operator==(const timecode& tc) const
{
	return(	frame  == tc.frame &&
			second == tc.second &&
			minute == tc.minute &&
			hour   == tc.hour &&
			type   == tc.type);
}

//------------------------------------------------------------------------------