#ifndef THREAD_H
#define THREAD_H

#include <OS.h>

class thread
{
public:

			thread(const char *aName, long aPriority = B_NORMAL_PRIORITY);
	virtual	~thread();
			
	status_t	GetInfo(thread_info *info);
	status_t	Kill();
	status_t	Run();
	status_t	Suspend();
	status_t	Rename(const char *newName);
	status_t	SetPriority(long newPriority);
	status_t	WaitForExit (long *thread_return_value);
	
	thread_id	ThreadID() {return fThreadID;};
	
	// This is the main routine that should be implemented
	// It is called by the Run() method when it's time to
	// actually start running the thread.
	virtual	status_t	ThreadMain()=0;
	
protected:
	thread_id	fThreadID;
	
private:

};


#endif
