// thread.cpp by William Adams

#include "thread.h"

#include <stdio.h>
#include <stdlib.h>

//========================================================
//
//========================================================

static status_t
thread_mainthread(void *data)
{	
	thread *aThread = (thread *)data;
  	return aThread->ThreadMain();
}

thread::thread(const char *aName, long aPriority)
	: fThreadID(-1)
{
	// spawn the thread
	fThreadID = spawn_thread(thread_mainthread, 
		aName, aPriority, this);
}

thread::~thread()
{
	long exitStatus;
	
	Kill();
	WaitForExit(&exitStatus);
}


status_t
thread::GetInfo(thread_info *info)
{
	return get_thread_info(fThreadID, info);
}


status_t	
thread::Kill()
{
	return kill_thread(fThreadID);
}

status_t	
thread::Run()
{
	return resume_thread(fThreadID);
}

status_t	
thread::Suspend()
{
	return suspend_thread(fThreadID);
}

status_t	
thread::Rename(const char *newName)
{
	return rename_thread(fThreadID, newName);
}

status_t	
thread::SetPriority(long newPriority)
{
	return set_thread_priority(fThreadID, newPriority);
}

status_t
thread::WaitForExit(long *exitStatus)
{
	return wait_for_thread(fThreadID, exitStatus);
}