//******************************************************************************
//
//	File: 			tcticker.cpp
//
//	Description: 	tcticker object class.
//
//	Written by:		Douglas Wright
//
//	Copyright 1998, Be Incorporated
//
//****************************************************************************

#include "tcticker.h"
#include "tick.h"


/*------------------------------------------------------------*/

tcticker::tcticker(uint8 fps)
	: ticker("tcticker", B_REAL_TIME_PRIORITY)
{
	SetPeriod(1000000.0 / fps);
}

/*------------------------------------------------------------*/

void
tcticker::Reset()
{
	fTimecode.Set(0,0,0,0);
}

/*------------------------------------------------------------*/

void	
tcticker::OutputTick(bigtime_t time, bigtime_t period, uint64 count)
{
	tick	t;
	
	t.fTime = time;
	t.fPeriod = period;
	t.fNumber = count;
	t.fTimecode = fTimecode;
	++fTimecode;
	
  	for (long i = 0; i < MAX_CONNECTIONS; i++) {
		if (fConnectionList[i]) {
	  		write_port(fConnectionList[i], TICK_MSG, &t, sizeof(t));
		}
  	}
}

/*------------------------------------------------------------*/