/* ++++++++++
	$Source: /net/bally/be/rcs/src/inc/os_p/scsi.h,v $
	$Revision: 1.10 $
	$Author: cyril $
	$Date: 1997/02/14 16:01:13 $
	Copyright (c) 1995 by Be Incorporated.  All Rights Reserved.

	Data structures and control calls for using the scsi driver
+++++ */

#ifndef _SCSI_H
#define _SCSI_H

#ifndef _SUPPORT_DEFS_H
#include <SupportDefs.h>
#endif

#ifndef _OS_H
#include <OS.h>
#endif

#ifndef _DRIVERS_H
#include <Drivers.h>
#endif

/* scsi device types */
/*------------------------*/
#define	SCSI_DISK		0x00
#define SCSI_TAPE		0x01
#define SCSI_PRINTER	0x02
#define SCSI_CPU		0x03
#define SCSI_WORM		0x04
#define SCSI_CD			0x05
#define SCSI_SCANNER	0x06
#define SCSI_OPTICAL	0x07
#define SCSI_JUKEBOX	0x08
#define SCSI_NETWORK	0x09


/* scsi device masks */
/*----------------------------------*/
#define SCSI_ALL_DEVICES_MASK	0xffffffff
#define SCSI_DISK_MASK		(1<<(SCSI_DISK))
#define SCSI_TAPE_MASK		(1<<(SCSI_TAPE))
#define SCSI_PRINTER_MASK	(1<<(SCSI_PRINTER))
#define SCSI_CPU_MASK		(1<<(SCSI_CPU))
#define SCSI_WORM_MASK		(1<<(SCSI_WORM))
#define SCSI_CD_MASK		(1<<(SCSI_CD))
#define SCSI_SCANNER_MASK	(1<<(SCSI_SCANNER))
#define SCSI_OPTICAL_MASK	(1<<(SCSI_OPTICAL))
#define SCSI_JUKEBOX_MASK	(1<<(SCSI_JUKEBOX))
#define SCSI_NETWORK_MASK	(1<<(SCSI_NETWORK))


/* control call codes for rescan scsi driver (/dev/scsi/rescan) */
/*-----------------------------------------------------*/
enum {
	SCSI_SCAN_FOR_DEVICES = B_DEVICE_OP_CODES_END + 1
};


/* control calls for all individual scsi device drivers */
/*------------------------------------------------------*/
enum {
	SCSI_INQUIRY = B_DEVICE_OP_CODES_END + 100,
	SCSI_EJECT
};

typedef struct {
	uchar	inquiry_data[36];	/* inquiry data (see SCSI standard) */
} scsi_inquiry;


/* control calls for scsi cd-rom driver */
/*--------------------------------------*/
enum {
	SCSI_GET_TOC = B_DEVICE_OP_CODES_END + 200,
	SCSI_PLAY_TRACK,
	SCSI_PLAY_POSITION,
	SCSI_STOP_AUDIO,
	SCSI_PAUSE_AUDIO,
	SCSI_RESUME_AUDIO,
	SCSI_GET_POSITION,
	SCSI_SET_VOLUME,
	SCSI_GET_VOLUME,
	SCSI_READ_CD,
	SCSI_SCAN
};

typedef struct {
	uchar	toc_data[804];	/* table of contents data (see SCSI standard) */
} scsi_toc;

typedef struct {
	uchar	start_track;	/* starting track */
	uchar	start_index;	/* starting index */
	uchar	end_track;		/* ending track */
	uchar	end_index;		/* ending index */
} scsi_play_track;

typedef struct {
	uchar	start_m;		/* starting minute */
	uchar	start_s;		/* starting second */
	uchar	start_f;		/* starting frame */
	uchar	end_m;			/* ending minute */
	uchar	end_s;			/* ending second */
	uchar	end_f;			/* ending frame */
} scsi_play_position;

typedef struct {
	uchar	position[16];	/* position data (see SCSI standard) */
} scsi_position;

typedef struct {
	uchar	flags;			/* A 1 in any position means change that field  */
							/* with port0_channel as bit 0 and port3_volume */
							/* as bit 7. */
	uchar	port0_channel;
	uchar	port0_volume;
	uchar	port1_channel;
	uchar	port1_volume;
	uchar	port2_channel;
	uchar	port2_volume;
	uchar	port3_channel;
	uchar	port3_volume;
} scsi_volume;

#define scsi_port0_channel	0x01
#define scsi_port0_volume	0x02
#define scsi_port1_channel	0x04
#define scsi_port1_volume	0x08
#define scsi_port2_channel	0x10
#define scsi_port2_volume	0x20
#define scsi_port3_channel	0x40
#define scsi_port3_volume	0x80

typedef struct {
	uchar	start_m;		/* starting minute */
	uchar	start_s;		/* starting second */
	uchar	start_f;		/* starting frame */
	uchar	length_m;		/* transfer length minute */
	uchar	length_s;		/* transfer length second */
	uchar	length_f;		/* transfer length frame */
	long	buffer_length;	/* size of read buffer */
	char*	buffer;			/* buffer to hold requested data */
	bool	play;			/* FALSE = don't play, TRUE = play */
} scsi_read_cd;

typedef struct {
	char	speed;			/* 0 = slow - 5x, 1 = fast - 12x */
	char	direction;		/* 1 = forward, 0 = stop scan, -1 = backward */
} scsi_scan;

#endif
