//	SimpleRecord.h
//	--------------
//	Copyright 1999, Be Incorporated.   All Rights Reserved.
//	This file may be used under the terms of the Be Sample Code License.

#if !defined(SimpleRecord_h)
#define SimpleRecord_h

#include <Locker.h>
#include <Window.h>
#include <View.h>
#include <FilePanel.h>

class BMediaFile;
class BMediaTrack;
class BButton;
class BBitmap;
class DevWindow;

class PeakView : public BView {
public:
		PeakView(BRect area);
		~PeakView();

		void Draw(BRect area);
		void Pulse();

		void SetMax(float maxL, float maxR)
			{
				if (mCurMaxL < maxL) mCurMaxL = maxL;
				if (mCurMaxR < maxR) mCurMaxR = maxR;
			}

private:

		enum {	//	indexes into color map
			BGCOLOR = 0,
			SEGCOLOR = 61,
			LITCOLOR = 55,
			PEAKCOLOR = 55+32,
			CLIPCOLOR = 42
		};
		BLocker mLock;
		float mCurMaxL;
		float mAvgMaxL;
		float mCurMaxR;
		float mAvgMaxR;
		BBitmap * mBits;

		void Generate();
};

class RecWindow : public BWindow {
public:
		RecWindow();
		~RecWindow();

		bool QuitRequested();
		void MessageReceived(BMessage * msg);

private:

		BMediaRecorder mRecorder;
		BBlockFIFO mFIFO;
		BMediaFile * mFile;
		BMediaTrack * mTrack;
		bool mRecording;
		BButton * mFileButton;
		BButton * mRecordButton;
		BButton * mStopButton;
		BButton * mDeviceButton;
		PeakView * mPeakView;
		BFilePanel mFilePanel;
		uint32 mFrameSize;
		thread_id mThread;
		int mPeakFormat;
		media_node * mDevice;
		DevWindow * mDevWin;

		void SetButtons();
		void SelectFile();
		void GotFile(BMessage * msg);
		void StartRecording();
		void StopRecording();
		void CloseFile();
		static void RecordHook(void * cookie, void * data, size_t size, const media_header & header);
		bool ConnectIt();
		static status_t buffer_flusher(void * data);
		void SelectDevice(BMessage * message);
};


class DevWindow : public BWindow {
public:
		DevWindow(BLooper * l);
		~DevWindow();
		void MessageReceived(BMessage * msg);
		bool QuitRequested();
private:
		BMessenger mThat;
};


#endif	//	SimpleRecord_h

