/*
	An empty Audio Producer
*/

#if !defined EMPTY_AUDIO_H
#define EMPTY_AUDIO_H

#include <MediaNode.h>
#include <BufferProducer.h>
#include <Controllable.h>

class BEndPoint;
class BBufferGroup;
class BTimedEventQueue;

class BEmptyAudio : public BBufferProducer, public BControllable
{
public:
			BEmptyAudio(const char *name);
			~BEmptyAudio();

/* from BMediaNode */
	virtual	void Start(
				bigtime_t performance_time);
	virtual	void Stop(
				bigtime_t performance_time,
				bool immediate);
	virtual	void Seek(
				bigtime_t media_time,
				bigtime_t performance_time);
	virtual	void TimeWarp(
				bigtime_t at_real_time,
				bigtime_t to_performance_time);
	virtual	void Preroll();
	virtual	status_t HandleMessage(
				int32 message,
				const void * data,
				size_t size);
			
/* from BBufferProducer */
	virtual status_t FormatSuggestionRequested(
				media_type type,
				int32 quality,
				media_format * format);
	virtual status_t FormatProposal(
				const media_source & output,
				media_format * format);
	virtual	status_t FormatChangeRequested(
				const media_source & source,
				const media_destination & destination,
				media_format * io_format,
				int32 * _deprecated_);
	virtual	status_t GetNextOutput(
				int32 * cookie,
				media_output * out_output);
	virtual	status_t DisposeOutputCookie(
				int32 cookie);	
	virtual	status_t SetBufferGroup(
				const media_source & for_source,
				BBufferGroup * group);
	virtual	status_t VideoClippingChanged(
				const media_source & for_source,
				int16 num_shorts,
				int16 * clip_data,
				const media_video_display_info & display,
				int32 * _deprecated_);
	virtual	status_t PrepareToConnect(
				const media_source & what,
				const media_destination & where,
				media_format * format,
				media_source * out_source,
				char * out_name);
	virtual	void Connect(
				status_t error, 
				const media_source & source,
				const media_destination & destination,
				const media_format & format,
				char * io_name);
	virtual	void Disconnect(
				const media_source & what,
				const media_destination & where);
	virtual	void LateNoticeReceived(
				const media_source & what,
				bigtime_t how_much,
				bigtime_t performance_time);
	virtual	void EnableOutput(
				const media_source & what,
				bool enabled,
				int32 * _deprecated_);
				
/* from BControllable */
	virtual	status_t GetParameterValue(
				int32 id,
				bigtime_t * last_change,
				void * value,
				size_t * ioSize);
	virtual	void SetParameterValue(
				int32 id,
				bigtime_t when,
				const void * value,
				size_t size);
	virtual	status_t StartControlPanel(
				BMessenger * out_messenger);

/* implementation */

private:
	static 	void RunThreadEntry(void *data);
			void Run();
			status_t WaitForMessages(bigtime_t wait_until);
			void HandleEvent();
			void SetupBuffer(BEndPoint *output);
			void FillBuffer(BEndPoint *output);
			
			bool mTimeToQuit;
			bool mRunning;
			bool mHookedUp;
			port_id mControlPort;
			thread_id mRunThread;
			media_format mFlexibleFormat;
			media_format mDefaultFormat;
			uint32 mFrameSize;
			uint32 mFrameCount;
			double mFrameDuration;
			bigtime_t mBufferDuration;
			uint32 mFrameTotal;
			bigtime_t mStartTime;
			bigtime_t mNextTime;
			BTimedEventQueue mEvents;
			BEndPoint mOutput;
			BBufferGroup *mMyGroup;
}
#endif EMPTY_AUDIO_H
