/*******************************************************************************
/
/	File:			SoundListView.h
/
/   Description:	View for organizing and playing back sound clips.
/
/	Copyright 1998-1999, Be Incorporated, All Rights Reserved
/
*******************************************************************************/


#if !defined( SoundListView_h )
#define SoundListView_h

#include <ListView.h>

class SoundListView : public BListView {
public:
		SoundListView(
				const BRect & area,
				const char * name,
				uint32 resize);
virtual	~SoundListView();

virtual void Draw(BRect updateRect);
virtual	void MouseDown(
				BPoint position);
virtual void MouseMoved(
				BPoint where, uint32 transit, const BMessage * dragMsg);
virtual	void FrameResized(
				float width,
				float height);
virtual	void AttachedToWindow();
virtual	bool AddItem(
				BListItem * item);
virtual	bool AddItem(
				BListItem * item,
				int32 index);

virtual void MessageReceived(BMessage* message);

	void SetDragFocus(bool focus);
	bool DragFocus() const;
									
private:
		void Calibrate(
				float width,
				float height);

	bool m_bDragFocus;				
};


#include <ListItem.h>

class SoundListItem : public BListItem {
	friend class SoundListView;
public:
		SoundListItem(
				const BEntry & entry,
				bool isTemp);
virtual	~SoundListItem();

virtual	void DrawItem(
				BView *owner,
				BRect bounds,
				bool complete = false);
virtual	void Update(
				BView *owner,
				const BFont * font);

		BEntry & Entry()
			{
				return m_entry;
			}
		bool IsTemp()
			{
				return m_isTemp;
			}
		void SetTemp(bool isTemp)
			{
				m_isTemp = isTemp;
			}
			
private:

		BBitmap * m_bitmap;
		BEntry m_entry;
		float m_baseline;
		float m_height;
		float m_above;
		float m_below;
		bool m_isTemp;

		void MakeBitmap();
};


#endif	/* SoundListView_h */

