/*******************************************************************************
/
/	File:			CaptureApp.cpp
/
/   Description:	Application for recording sound.
/
/	Copyright 1998, Be Incorporated, All Rights Reserved
/
*******************************************************************************/

#include <stdio.h>

#include <Message.h>
#include <String.h>
#include <Alert.h>
#include <Path.h>
#include <Node.h>
#include <NodeInfo.h>

#include "CaptureApp.h"
#include "CaptureWindow.h"


CaptureApp::CaptureApp(const char * signature) :
	BApplication(signature), m_pCWin(0)
{
}

CaptureApp::~CaptureApp()
{
}

void
CaptureApp::MessageReceived(
	BMessage * message)
{
	switch (message->what) {
	// insert future application message handling here
	default:
		BApplication::MessageReceived(message);
		break;
	}
}

void
CaptureApp::RefsReceived(
	BMessage * message)
{
	entry_ref ref;
	int32 i=0;
	while (message->FindRef("refs", i++, &ref) == B_OK) {
		CaptureWindow * cw = GetCaptureWindow();
		BEntry entry(&ref);
		if (entry.InitCheck() != B_OK) {
			BString errStr = "Error opening file: bad file reference.\n";
			BAlert* pAlert = new BAlert("RefsReceived error",
				errStr.String(), "OK");
			pAlert->Go();
			return;
		}
		
		BPath path;
		entry.GetPath(&path);
		BNode node(&entry);
		BNodeInfo info(&node);
		if (info.InitCheck() == B_OK) {
			char type[B_MIME_TYPE_LENGTH];
			if (info.GetType(type) == B_OK) {
				if (strcmp(type, "application/x-vnd.Be-RAWM")) {
					BString errStr;
					errStr << "Error opening file: " << path.Path();
					errStr << "\nNot a raw audio file.\n";
					BAlert* pAlert = new BAlert("RefsReceived error",
						errStr.String(), "OK");
					pAlert->Go();
				} else	if (cw && cw->Lock()) {
					cw->AddSoundItem(entry);
					cw->Unlock();
				}	
			} else {
				BString errStr = "Error opening file: couldn't find MIME type.\n";
				BAlert* pAlert = new BAlert("RefsReceived error",
					errStr.String(), "OK");
				pAlert->Go();
			}
		} else {
			BString errStr = "Error opening file: bad file reference.\n";
			BAlert* pAlert = new BAlert("RefsReceived error",
				errStr.String(), "OK");
			pAlert->Go();
		}		
	}
}

void
CaptureApp::ReadyToRun()
{
	BApplication::ReadyToRun();
	GetCaptureWindow(); // creates it if it doesn't already exist
}

CaptureWindow*
CaptureApp::GetCaptureWindow()
{
	if (! m_pCWin) {
		m_pCWin = new CaptureWindow();
		m_pCWin->IWindow();
		m_pCWin->Show();
	}
	return m_pCWin;
}

