/*******************************************************************************
/
/	File:			CaptureWindow.h
/
/   Description:	Window for recording sound and arranging clips.
/
/	Copyright 1998-1999, Be Incorporated, All Rights Reserved
/
*******************************************************************************/


#if !defined( _CaptureWindow_h )
#define _CaptureWindow_h

#include <Window.h>
#include <MediaNode.h>
#include <Directory.h>
#include <File.h>
#include <Entry.h>
#include <FilePanel.h>

class BMediaRoster;
class BBox;
class BButton;
class BCheckBox;
class BTextControl;
class BMenuField;
class SoundConsumer;
class SoundProducer;
class SoundListView;
class BScrollView;

class CaptureWindow : public BWindow {
public:
		CaptureWindow();
virtual	~CaptureWindow();
		status_t IWindow();

virtual	bool QuitRequested();
virtual	void MessageReceived(
				BMessage * message);
virtual	void WorkspaceActivated(
				int32 workspace,
				bool active);

		enum {
			RECORD = 'cw00',			//	command messages
			PLAY,
			STOP,
			SAVE,
			INPUT_SELECTED = 'cW00',	//	control messages
			LENGTH_CHANGED,
			VOX_START,
			VOX_FRAMES,
			VOX_THRESHOLD,
			SOUND_SELECTED,
			STOP_PLAYING,
			STOP_RECORDING,
		};

		void AddSoundItem(const BEntry& entry, bool temp = false);
		
private:
		BMediaRoster * m_roster;
		BBox * m_background;
		BButton * m_record;
		BButton * m_play;
		BButton * m_stop;
		BButton * m_save;
		BCheckBox * m_vox;
		BTextControl * m_length;
		BMenuField * m_input;
		media_input m_curInput;
		media_output m_myNode;
		SoundConsumer * m_recordNode;
		SoundProducer * m_playNode;
		bool m_recOnVox;
		uint16 m_voxFrames;
		uint32 m_voxThreshold;
		bool m_recording;
		BSlider* m_voxFrameSlider;
		BSlider* m_voxThresholdSlider;
		SoundListView * m_soundList;
		BScrollView * m_scroller;
		BDirectory m_tempDir;
		int m_tempCount;

		enum BtnState {
			btnPaused,
			btnRecording,
			btnPlaying
		};
		BtnState m_buttonState;
		BEntry m_recEntry;

		BFile m_recFile;
		off_t m_recLimit;
		off_t m_recSize;

		media_node m_audioInputNode;
		media_output m_audioOutput;
		media_input m_recInput;

		BFile m_playFile;
		off_t m_playLimit;
		off_t m_playSize;
		
		media_node m_audioMixerNode;
		media_input m_audioMixerInput;
		media_output m_playOutput;

		BFilePanel m_savePanel;
		
		void Record(
				BMessage * message);
		void Play(
				BMessage * message);
		void Stop(
				BMessage * message);
		void Save(
				BMessage * message);
		void DoSave(
				BMessage * message);
		void Vox(
				BMessage * message);
		void VoxFrames(
				BMessage* message);
		void VoxThreshold(
				BMessage* message);
		void Input(
				BMessage * message);
		void Length(
				BMessage * message);
		void Selected(
				BMessage * message);

		status_t MakeRecordConnection(
				const media_node & input);
		status_t BreakRecordConnection();
		status_t StopRecording();
		
		status_t MakePlayConnection(
				const media_raw_audio_format & format);
		status_t BreakPlayConnection();
		status_t StopPlaying();

		status_t NewTempName(
				char * buffer);
		void CalcSizes(
				float min_width,
				float min_height);
		void SetButtonState(
				BtnState state);
		void UpdateButtons();
		void ErrorAlert(
				const char * action,
				status_t err);

static	void RecordFile(
				void * cookie, 
				bigtime_t timestamp, 
				void * data,
				size_t size, 
				const media_raw_audio_format & format);
static	void NotifyRecordFile(
				void * cookie,
				int32 code,
				...);

static	void PlayFile(
				void * cookie, 
				bigtime_t timestamp, 
				void * data,
				size_t size, 
				const media_raw_audio_format & format);
static	void NotifyPlayFile(
				void * cookie,
				int32 code,
				...);
};

#endif	/*	_CaptureWindow_h */

