/*******************************************************************************
/
/	File:			TestApp.h
/
/   Description:	A simple application that tests the Selector Node.
/
/	Copyright 1999, Be Incorporated, All Rights Reserved
/
*******************************************************************************/

#ifndef _TestApp_h
#define _TestApp_h

#include <Application.h>
#include "TestBench.h"
#include "ArgvHandler.h"

class TestApp : public BApplication
{
public:
	TestApp();
	void ReadyToRun();
	void ArgvReceived(int32 argc, char** argv);
	void Quit();
	
private:
	bool HandleArg();
	void PrintHelp();
	status_t StartTestNode();
	void StartTestWindow();
	
	status_t AddReader(const char* filename);
	status_t AddOutput();
	
	
	TestBench m_tester;
	ArgvHandler m_argv;
	
	bool m_bControls;
	bool m_bHelp;
	bool m_bHasFiles;
	bool m_bInitOK;
	
	int8 m_initSel;
};

#endif /* _TestApp_h */