/*******************************************************************************
/
/	File:			SoundTypes.h
/
/   Description:	Useful definitions and declarations for SoundConsumer
/                   and SoundProducer.
/
/	Copyright 1998-1999, Be Incorporated, All Rights Reserved
/
*******************************************************************************/

#if ! defined( _SoundTypes_h )
#define _SoundTypes_h

#include <MediaDefs.h>

//	This is a common hook function interface for
//	SoundConsumer and SoundProducer to use.
typedef void (*SoundProcessFunc)(void * cookie,
	bigtime_t timestamp, void * data, size_t datasize,
	const media_raw_audio_format & format);
typedef void (*SoundNotifyFunc)(void * cookie,
	int32 code, ...);

//	These are special codes that we use in the Notify
//	function hook.
enum {
	B_WILL_START = 1,		//	performance_time
	B_WILL_STOP,			//	performance_time immediate
	B_WILL_SEEK,			//	performance_time media_time
	B_WILL_TIMEWARP,		//	real_time performance_time
	B_CONNECTED,			//	name (char*)
	B_DISCONNECTED,			//
	B_FORMAT_CHANGED,		//	media_raw_audio_format*
	B_NODE_DIES,			//	node will die!
	B_HOOKS_CHANGED,		//	
	B_OP_TIMED_OUT,			//	timeout that expired -- Consumer only
	B_PRODUCER_DATA_STATUS,	//	status performance_time -- Consumer only
	B_LATE_NOTICE			//	how_much performance_time -- Producer only
};

#endif /* _SoundTypes_h */
