/*
	
	SoundFileReader.h
	
	Implements a sound file reader node.
	
	Copyright 1999 Be Incorporated, All Rights Reserved.

*/

#ifndef _SoundFileReader_h
#define _SoundFileReader_h

#include "SoundProducer.h"

class BSound;

class SoundFileReader : public SoundProducer
{
public:
	SoundFileReader(const char* name, const entry_ref* ref = 0);
	~SoundFileReader();

	status_t SetRef(const entry_ref* ref);
	
protected:
	virtual bigtime_t ProcessingLatency();
	virtual void Play(
		bigtime_t time,
		void* data,
		size_t size,
		const media_raw_audio_format& format);
	virtual void Notify(
		int32 cause,
		...);
		
private:
	void ClearSound();
	
	BSound* m_sound;
	off_t m_pos;
	bool m_bPlaying;
	bool m_bLoop;
};

#endif /* _SoundFileReader_h */
