/*******************************************************************************
/
/	File:			MediaNodeWrapper.h
/
/   Description:	A application-based object-oriented API for
/					working with media_nodes.
/
/	Copyright 1999, Be Incorporated, All Rights Reserved
/
*******************************************************************************/

#ifndef _MediaNodeWrapper_h
#define _MediaNodeWrapper_h

#include <MediaNode.h>

class MediaNodeWrapper
{
public:
	// Constructors, destructors, operators
	MediaNodeWrapper();
	
	// locked = true means that you shouldn't be able to "do
	// anything" to the node; i.e. start/stop/slave
	// will have no effect (NOTE: but Release still will!).
	// Use this to wrap around system nodes, such as the audio
	// output, that you shouldn't be tampering with.
	MediaNodeWrapper(const media_node& node, bool locked = false);
	MediaNodeWrapper(const MediaNodeWrapper& node);
	~MediaNodeWrapper();
	
	MediaNodeWrapper& operator=(const MediaNodeWrapper& node);
	
	void Start(bigtime_t tpStart) const;
	void Stop(bigtime_t tpStop, bool synchronous) const;
	// SlaveTo sets this node's time source to whatever the
	// master node's time source is, NOT necessarily to the
	// master node itself!
	void SlaveTo(MediaNodeWrapper master) const;
	BTimeSource* GetTimeSource() const;
	
	// GetFreeOutput/GetFreeInput simply return the first
	// available output/input from the node.
	status_t GetFreeOutput(media_output* output) const;
	status_t GetFreeInput(media_input* input) const;

	// GetLatency returns the TOTAL latency for the node.
	status_t GetLatency(bigtime_t* latency) const;
	
	void Release() const;
	
private:
	media_node m_node;
	bool m_locked;
	bool m_init;
};

#endif /* _MediaNodeWrapper_h */