/*******************************************************************************
/
/	File:			ArgvHandler.h
/
/   Description:	A simple class for processing argv's.
/
/	Copyright 1999, Be Incorporated, All Rights Reserved
/
*******************************************************************************/

#ifndef _ArgvHandler_h
#define _ArgvHandler_h

#include <SupportDefs.h>

class ArgvHandler
{
public:
	void Init(int32 argc, char** argv, int32 initPos = 0);
	
	// NextArg returns the current argument and increments
	// the argument pointer.
	status_t NextArg(char** arg);
	status_t NextArg(double* val);
	status_t NextArg(int32* val);
	status_t NextArg(int8* val);
	
	// PrevArg decrements the arguemnt pointer and returns
	// the new argument.
	status_t PrevArg(char** arg);	
	status_t PrevArg(double* val);
	status_t PrevArg(int32* val);
	status_t PrevArg(int8* val);
	
private:
	bool check_range(int32 index) const
	{ return (index >= 0 && index < m_argc); }

	status_t ConvertToInt32(char* arg, int32* val);
	status_t ConvertToDouble(char* arg, double* val);
		
	int32 m_argc;
	char** m_argv;
	int32 m_curPos;
};

#endif /* _ArgvHandler_h */