/*******************************************************************************
/
/	File:			TestBench.h
/
/   Description:	A generic framework for testing a media node.
/
/	Copyright 1999, Be Incorporated, All Rights Reserved
/
*******************************************************************************/

#ifndef _TestBench_h
#define _TestBench_h

#include <vector>
#include "MediaNodeWrapper.h"

class Connection;

class TestBench
{
public:
	TestBench();
	~TestBench();
	
	// Start hooks up the outputs and inputs to the test
	// node, initializes the node with the specified message,
	// and starts the whole system running.
	status_t Start(const media_node& node, int32 what, const void* data, size_t size);
	
	// Stop tears down the system and releases all of the nodes involved.
	void Stop();
	
	// AddInput/Output adds the node as one of the nodes upstream or
	// downstream from the test node.
	// lock says whether it's OK to start, stop, and otherwise muck
	// with the node (false == it is OK).
	void AddInput(const media_node& node, bool lock = false);
	void AddOutput(const media_node& node, bool lock = false);
	
private:
	status_t Hookup();
	status_t SetupTest();
	status_t StartNodes();
	status_t StopNodes();
	status_t TearDown();
	
	status_t ConnectTestInput(const media_node& srcNode);
	status_t ConnectTestOutput(const media_node& destNode);
	status_t SlaveToNode(const media_node& slave, const media_node& master);
	status_t DisconnectTestInputs();
	status_t DisconnectTestOutput();
	
	bigtime_t ChainLatency();
	
	bool m_bRunning;

	vector<MediaNodeWrapper> m_inputNodes;
	vector<MediaNodeWrapper> m_outputNodes;
	vector<Connection*> m_inputs;
	vector<Connection*> m_outputs;
	
	MediaNodeWrapper m_testNode;
};

#endif /* _TestBench_h */