/*******************************************************************************
/
/	File:			SelectorAddOn.h
/
/   Description:	An add-on that contains the Selector Node.
/
/	Copyright 1999, Be Incorporated, All Rights Reserved
/
*******************************************************************************/

#ifndef _SelectorAddOn_h
#define _SelectorAddOn_h

#include <MediaAddOn.h>

class SelectorAddOn : public BMediaAddOn
{
public:
	SelectorAddOn(image_id image);
	~SelectorAddOn();
		
// BMediaAddOn methods
public:
	virtual status_t InitCheck(const char** out_failure_test);
	virtual int32 CountFlavors();
	virtual status_t GetFlavorAt(int32 n, const flavor_info** out_info);
	virtual BMediaNode* InstantiateNodeFor(const flavor_info* info, BMessage* config, status_t* out_error);
	virtual status_t GetConfigurationFor(BMediaNode* your_node, BMessage* into_message);
	virtual bool WantsAutoStart();
	virtual status_t AutoStart(int in_count, BMediaNode** out_node, int32* out_internal_id, bool* out_has_more);

private:
	flavor_info* m_flavor;
	media_format* m_formats;
};

#endif /* _SelectorAddOn_h */