/*******************************************************************************
/
/	File:			MotherNode.h
/
/   Description:  MotherNode is a class that will take care of things for you.
/				  She spawns a thread to wait for your messages and lets you
/				  know when you need to handle an event.  You have to tell her
/				  about your latency, and override HandleEvent.
/
/	Copyright 1997-98, Be Incorporated, All Rights Reserved
/
*******************************************************************************/


#if !defined(_MOTHER_NODE_H)
#define _MOTHER_NODE_H

#include <MediaNode.h>
#include <TimedEventQueue.h>

class MotherNode :
	public virtual BMediaNode
{
protected:
		/* this has to be on top rather than bottom to force a vtable in mwcc */
virtual	~MotherNode();
		MotherNode();

public:
/* from MediaNode */		
virtual	void NodeRegistered();
virtual	void Start(
				bigtime_t performance_time);
virtual	void Stop(
				bigtime_t performance_time,
				bool immediate);
virtual	void Seek(
				bigtime_t media_time,
				bigtime_t performance_time);
virtual	void TimeWarp(
				bigtime_t at_real_time,
				bigtime_t to_performance_time);

/* Mother implementation */
		bool IsStopped(); /* am i started? */
/* Override this to do your chores */
virtual	void HandleEvent(const bigtime_t performanceTime,
				const int32 what,
			 	const void *pointer,
				const uint32 cleanup,
				const int64 data);
protected:
/* this is where mom keeps her lists */
	BTimedEventQueue *EventQueue(){ return &_mEventQueue; }
	uint32 Priority() { return _mPriority; }
	bigtime_t EventLatency() { return _mEventLatency; }
/* call if you're going to be late! */
	void SetEventLatency(bigtime_t latency);
/* you need to prioritize your life */
	void SetPriority(int32 priority);
/* from birth */
	void Go();
/* to death */
	void Quit();

private:
/* it must be thanksgiving! */		
virtual	status_t _Reserved_MotherNode_0(void *);
virtual	status_t _Reserved_MotherNode_1(void *);
virtual	status_t _Reserved_MotherNode_2(void *);
virtual	status_t _Reserved_MotherNode_3(void *);
virtual	status_t _Reserved_MotherNode_4(void *);
virtual	status_t _Reserved_MotherNode_5(void *);
virtual	status_t _Reserved_MotherNode_6(void *);
virtual	status_t _Reserved_MotherNode_7(void *);

static 	int32 _ControlThreadStart(void*);
void _ControlLoop();

/* mom takes care of things */
		void _PHandleEvent();
		BTimedEventQueue _mEventQueue;
		thread_id _mControlThread;
		uint32 _mPriority;
		bigtime_t _mEventLatency;
		bool _mRunning;

/* turkey for weeks! */		
		bool _mReservedBool[4];
		uint32 _reserved_mother_node_[8];

};

#endif /* _MOTHER_NODE_H */

