
#if !defined(_RT_ALLOC_H)
#define _RT_ALLOC_H

#include <SupportDefs.h>

#if defined(__cplusplus)
extern "C" {
#endif

typedef struct rtm_pool rtm_pool;

/* If out_pool is NULL, the default pool will be created if it isn't already. */
/* If the default pool is already created, it will return EALREADY. */
status_t rtm_create_pool(rtm_pool ** out_pool, size_t total_size);
status_t rtm_delete_pool(rtm_pool * pool);
/* If NULL is passed for pool, the default pool is used (if created). */
void * rtm_alloc(rtm_pool * pool, size_t size);
status_t rtm_free(void * data);
/* status_t rtm_realloc(void ** data, size_t new_size); */	/* not yet implemented */
status_t rtm_size_for(void * data);

/* Return the default pool, or NULL if not yet initialized */
rtm_pool * rtm_default_pool();

#if defined(__cplusplus)
}
#endif

#endif // _RT_ALLOC_H

