
#ifndef CHROME_VIDEO_H
#define CHROME_VIDEO_H

#include <BufferFilter.h>

class ChromeVideo : public BBufferFilter
{
	public:
								ChromeVideo(BMediaAddOn *addOn);
		virtual					~ChromeVideo();
		
	protected:
		/* BBufferFilter functions */
		/* initialization and clean-up */
		virtual void			Init();
		virtual void			CleanUp();
		virtual void			PublishLatency(bigtime_t *latency);
			
		virtual status_t		StartNow();
		virtual status_t		StopNow();
		virtual status_t		SeekNow(bigtime_t seekTo);
		virtual status_t		WarpNow(bigtime_t warpTo);

		virtual void			HandleEvent(const bigtime_t time, const int32 what,
												const void *pointer, const uint32 flags, const int64 data);

		virtual void			FilterBuffer(BBuffer *inBuffer);
		virtual BBufferGroup *	CreateBufferGroup(media_output &output);

		virtual void			Preroll();
		/* BBufferConsumer */
		virtual status_t		AcceptFormat(const media_destination &dest, media_format *format);
		virtual status_t		Connected(const media_source & producer, const media_destination &where,
											const media_format &with_format, media_input *out_input);
		/* BBufferProducer */
		virtual status_t		FormatChanged(const media_source &producer, const media_destination &consumer,
											int32 from_change_format, const media_format &format);
		virtual status_t		FormatSuggestionRequested(media_type type, int32 quality, media_format *format);
		virtual status_t		FormatProposal(const media_source &output, media_format *format);
		virtual status_t		FormatChangeRequested(const media_source &source, const media_destination &dest,
											media_format *io_format, int32 *out_change_count);
		virtual status_t		VideoClippingChanged(const media_source &for_source, int16 num_shorts,
										int16 *clip_data, const media_video_display_info &display,
										int32 * out_from_change_count);
		virtual status_t		PrepareToConnect(const media_source &what, const media_destination &where,
									media_format *format, media_source *out_source, char *out_name);
		virtual void			Connect(status_t error, const media_source &source,
									const media_destination &dest, const media_format &format,
									char * io_name);
		virtual void			LateNoticeReceived(const media_source &what, bigtime_t how_much,
									bigtime_t performance_time);
		virtual status_t		SetBufferGroup(const media_source &for_source, BBufferGroup *group);	
	private:
		uint32					fInBufferSize;
		uint32					fOutBufferSize;
};

#endif
