/* ChromeTV.h */

#ifndef CHROME_TV_H
#define CHROME_TV_H

#include <Application.h>

#include "ChromeVideo.h"

class ChromeTVApp : public BApplication {
	public:
							ChromeTVApp();
		virtual				~ChromeTVApp();
		
		void				ReadyToRun();
		virtual bool		QuitRequested();

	private:
		status_t			SetUpNodes();
		void				TearDownNodes();
		
		BMediaRoster *		fMediaRoster;
		
		media_node			fTimeSourceNode;
		media_node			fProducerNode;
		media_node			fConsumerNode;
		
		ChromeVideo *		fFilter;

		media_output		fProducerOut, fFilterOut;
		media_input			fFilterIn, fConsumerIn;
};

#include <Window.h>

class StopWindow : public BWindow {
	
	public:
							StopWindow();
		virtual	bool 		QuitRequested();
};


#endif