
#ifndef _BUFFER_FILTER_H
#define _BUFFER_FILTER_H



class BTimedEventQueue;

#include <BufferConsumer.h>
#include <BufferProducer.h>

struct MediaInputConnection {
	media_input			in;
	status_t			data_status;
	bigtime_t			latency;
	bool				own_buffers;
	BBufferGroup *		buffers;
};

struct MediaOutputConnection {
	media_output		out;
	bool				enabled;
	bigtime_t			downstream_latency;
	bigtime_t			processing_latency;
	bool				own_buffers;
	BBufferGroup *		buffers;
};

class BBufferFilter : public BBufferConsumer, public BBufferProducer
{
	public:
									BBufferFilter(const char *name, media_type consumed, media_type produced,
														BMediaAddOn *addOn = NULL);
		virtual						~BBufferFilter();
		
		/* main loop thread entry function */
		static status_t 		EnterMainLoop(void *arg);
		
		port_id					ControlPort() const;
		BMediaAddOn *			AddOn(int32 *internal_id) const;

	protected:
		/* roster accessor */
		BMediaRoster *			Roster() const;
		
		/* initialization and clean-up */
		virtual void			Init();
		virtual void			CleanUp();
	
		/* tell the node what your initial estimates for audio and video latency */
		virtual void			PublishLatency(bigtime_t *latency);
		virtual void			PublishMediaFormats();
		virtual void			SetUpConnections();
		
		/* handle basic media node events */
		virtual status_t		StartNow();
		virtual status_t		StopNow();
		virtual status_t		SeekNow(bigtime_t seekTo);
		virtual status_t		WarpNow(bigtime_t warpTo);

		/* Event Handling */
		virtual void			HandleEvent(const bigtime_t time, const int32 what,
												const void *pointer, const uint32 flags, const int64 data);
		
		/* Buffer manipulation */
		virtual void			FilterBuffer(BBuffer *inBuffer);
		virtual BBufferGroup *	CreateBufferGroup(media_output &output);
		virtual	BTimedEventQueue *CreateEventQueue();
		
		/* Message Handling */
		status_t				WaitForMessages(bigtime_t waitUntil);
		virtual status_t		HandleMessage(int32 code, const void *msg, size_t size);
		
		/* connection management */
		MediaInputConnection	fIn;
		MediaOutputConnection	fOut;
		
		bigtime_t				fSchedulingLatency;
		
		/* Event Queue */
		BTimedEventQueue *		fEvents;
		
		/* protected MediaNode functions */
		virtual	void			Start(bigtime_t performance_time);
		virtual void			Stop(bigtime_t performance_time, bool immediate);
		virtual void			Seek(bigtime_t to_media_time, bigtime_t at_real_time);
		virtual void			SetRunMode(run_mode mode);
		virtual void			TimeWarp(bigtime_t at_real_time, bigtime_t to_performance_time);
		virtual void			Preroll();
		virtual void			SetTimeSource(BTimeSource *time_source);
		
		/* protected BBufferConsumer functions */
		virtual status_t		AcceptFormat(const media_destination &dest, media_format *format);
		virtual status_t		GetNextInput(int32 *cookie, media_input *out_input);
		virtual void			DisposeInputCookie(int32 cookie);
		virtual void			BufferReceived(BBuffer *buffer);
		virtual void			ProducerDataStatus(const media_destination &for_whom, int32 status, bigtime_t at_media_time);
		virtual status_t		GetLatencyFor(const media_destination &for_whom, bigtime_t *out_latency, media_node_id *out_timesource);
		virtual status_t		Connected(const media_source & producer, const media_destination &where,
											const media_format &with_format, media_input *out_input);
		virtual void			Disconnected(const media_source &producer, const media_destination &where);
		virtual status_t		FormatChanged(const media_source &producer, const media_destination &consumer,
											int32 from_change_format, const media_format &format);
		
		/* protected BBufferProducer functions */
		virtual status_t		FormatSuggestionRequested(media_type type, int32 quality, media_format *format);
		virtual status_t		FormatProposal(const media_source &output, media_format *format);
		virtual status_t		FormatChangeRequested(const media_source &source, const media_destination &dest,
											media_format *io_format, int32 *out_change_count);
		virtual status_t		GetNextOutput(int32 *cookie, media_output *out_output);
		virtual status_t		DisposeOutputCookie(int32 cookie);
		virtual status_t		SetBufferGroup(const media_source &for_source, BBufferGroup *group);
		virtual status_t		VideoClippingChanged(const media_source &for_source, int16 num_shorts,
									int16 *clip_data, const media_video_display_info &display,
									int32 * out_from_change_count);
		virtual status_t		GetLatency(bigtime_t *out_latency);
		virtual status_t		PrepareToConnect(const media_source &what, const media_destination &where,
									media_format *format, media_source *out_source, char *out_name);
		virtual void			Connect(status_t error, const media_source &source,
									const media_destination &dest, const media_format &format,
									char * io_name);
		virtual void			Disconnect(const media_source &what, const media_destination &where);
		virtual void			LateNoticeReceived(const media_source &what, bigtime_t how_much,
									bigtime_t performance_time);
		virtual void			EnableOutput(const media_source &what, bool enabled, int32 *change_tag);
		virtual status_t		SetPlayRate(int32 numer, int32 denom);


	private:
		/* thread management */
		port_id					fControlPort;
		thread_id				fMainThread;
		void					MainLoop();
		
		/* loop management */
		bool					fTimeToQuit, fRunning;
		bigtime_t				fMediaTime;			// probably need an accessor for this!
		
		/* message management */
		char					fMsg[B_MEDIA_MESSAGE_SIZE];
		int32					fCode;
		
		/* connection Management */
//		bigtime_t				AdjustDataStatus(bigtime_t perfTime);
//		void					ConsumeQueuedBuffer();
//		void					SendQueuedBuffer();
		BMediaAddOn *			fAddOn;
		BMediaRoster *			fRoster;

};


#endif