//--------------------------------------------------------------------
//	
//	Status.cpp
//
//	Written by: Robert Polic
//	
//	Copyright 1996 Be, Inc. All Rights Reserved.
//	
//--------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/stat.h>

#include <StringView.h>

#ifndef STATUS_H
#include "Status.h"
#endif

#define	VIEW_COLOR			216

//====================================================================

TStatusWindow::TStatusWindow(BRect rect, long a_sem, char *status)
			  :BWindow(rect, "", B_MODAL_WINDOW, 0)
{
	BRect		r;

	sem = a_sem;
	r.Set(0, 0, STATUS_WIDTH, STATUS_HEIGHT);
	fView = new TStatusView(r, 0, status);
	Lock();
	AddChild(fView);
	Unlock();
	Show();
}

//--------------------------------------------------------------------

void TStatusWindow::MessageReceived(BMessage *msg)
{
	switch (msg->what) {
		case OK:
			strcpy(tmp_string, fView->fStatus->Text());
			release_sem(sem);
			break;
		case CANCEL:
			tmp_string[0] = 0;
			release_sem(sem);
			break;
	}
}


//====================================================================

TStatusView::TStatusView(BRect rect, BWindow *window, char *status)
			:BView(rect, "", B_FOLLOW_ALL, B_WILL_DRAW)
{
	rgb_color	c;

	fWindow = window;
	fString = status;

	c.red = c.green = c.blue = VIEW_COLOR;
	SetViewColor(c);
	//SetFontName("Erich");
	SetFontSize(9);
	SetDrawingMode(B_OP_OVER);
}

//--------------------------------------------------------------------

void TStatusView::AttachedToWindow(void)
{
	BRect		r;
	BStringView	*tp;

	r.Set(STATUS_FIELD_H, STATUS_FIELD_V,
		  STATUS_FIELD_WIDTH,
		  STATUS_FIELD_V + STATUS_FIELD_HEIGHT);
	fStatus = new BTextControl(r, "", STATUS_TEXT, fString,
							new BMessage(STATUS));
	AddChild(fStatus);
	//fStatus->SetFontName("Erich");
	fStatus->SetFontSize(9);
	fStatus->SetDivider(/* StringWidth(STATUS_TEXT) + 6*/ 0);
	fStatus->BTextControl::MakeFocus(TRUE);

	r.OffsetBy(0.0, -18.0);
	tp = new BStringView(r, "", "Please name this printer:");
	tp->SetFont(be_bold_font);
	AddChild(tp);
	
	r.Set(OK_BUTTON_H, OK_BUTTON_V,
		  OK_BUTTON_H + BUTTON_WIDTH,
		  OK_BUTTON_V + BUTTON_HEIGHT);
	fOK = new BButton(r, "", OK_BUTTON_TEXT, new BMessage(OK));
	AddChild(fOK);

	r.Set(CANCEL_BUTTON_H, CANCEL_BUTTON_V,
		  CANCEL_BUTTON_H + BUTTON_WIDTH,
		  CANCEL_BUTTON_V + BUTTON_HEIGHT);
	fCancel = new BButton(r, "", CANCEL_BUTTON_TEXT, new BMessage(CANCEL));
	AddChild(fCancel);

	fOK->MakeDefault(TRUE);
}

//--------------------------------------------------------------------

void TStatusView::Draw(BRect where)
{
	BRect	r;

	r = Bounds();

	SetHighColor(255, 255, 255);
	StrokeLine(BPoint(r.left, r.top), BPoint(r.right, r.top));
	StrokeLine(BPoint(r.left, r.top + 1), BPoint(r.left, r.bottom - 1));
	StrokeLine(BPoint(r.right, r.top + 1), BPoint(r.right, r.bottom));
	StrokeLine(BPoint(r.right - 1, r.bottom - 1), BPoint(r.left, r.bottom - 1));
}

//--------------------------------------------------------------------

void TStatusView::MessageReceived(BMessage *msg)
{
	BMessage	*message;

	switch (msg->what) {
		case STATUS:
			break;
		case OK:
			//message->AddString("status", fStatus->Text());
			// will fall through
			break;
		case CANCEL:
			break;
	}
}
