//
// Hello World 2000
//
// Copyright 1998, Be Incorporated
//
// Written by: Eric Shepherd
//

#include <Application.h>
#include <Window.h>
#include <View.h>


//
// HelloView class
//
// This class defines the view in which the "Hello World"
// message will be drawn.
//
class HelloView : public BView {
	public:
						HelloView(BRect frame);
		virtual void	Draw(BRect updateRect);
};


//
// HelloView::HelloView
//
// Constructs the view we'll be drawing in.
// As you see, it doesn't do much.
//
HelloView::HelloView(BRect frame)
			: BView(frame, "HelloView", B_FOLLOW_ALL_SIDES, B_WILL_DRAW) {
}


//
// HelloView::Draw
//
// This function is called whenever our view
// needs to be redrawn.  This happens only because
// we specified B_WILL_DRAW for the flags when
// we created the view (see the constructor).
//
// The updateRect is the rectangle that needs to be
// redrawn.  We're ignoring it, but you can use it to
// speed up your refreshes for more complex programs.
//
void HelloView::Draw(BRect updateRect) {
	MovePenTo(BPoint(20,75));			// Move pen
	DrawString("Hello, world!");
}


//
// HelloWindow class
//
// This class defines the hello world window.
//
class HelloWindow : public BWindow {
	public:
						HelloWindow(BRect frame);
		virtual bool	QuitRequested();
};


//
// HelloWindow::HelloWindow
//
// Constructs the window we'll be drawing into.
//
HelloWindow::HelloWindow(BRect frame)
			: BWindow(frame, "Hello World", B_TITLED_WINDOW,

	B_NOT_RESIZABLE|B_NOT_ZOOMABLE) {
	AddChild(new HelloView(Bounds()));
	Show();
}


//
// HelloWindow::QuitRequested
//
// When the window is closed (either by the user clicking
// the close box or by some other means),
// this function is called.  You can add code to this
// to give the user the opportunity to save their document,
// or perform other such activities.
//
// Here we just give permission to close the window.
//
bool HelloWindow::QuitRequested() {
	be_app->PostMessage(B_QUIT_REQUESTED);
	return true;
}


//
// HelloApp class
//
// This class, derived from BApplication, defines the
// Hello World application itself.
//
class HelloApp : public BApplication {
	public:
						HelloApp();

	private:
		HelloWindow		*theWindow;
};


//
// HelloApp::HelloApp
//
// The constructor for the HelloApp class.  This
// will create our window.
//
HelloApp::HelloApp()
			: BApplication("application/x-vnd.Be-HelloWorld") {
	BRect windowRect;

	windowRect.Set(50,50,200,200);
	theWindow = new HelloWindow(windowRect);
}


//
// main
//
// The main() function's only real job in a basic BeOS
// application is to create the BApplication object,
// run it, and delete it when it terminates.
//
void main(void) {
	HelloApp *theApp;		// Pointer to our application object
	theApp = new(HelloApp);
	theApp->Run();
	delete theApp;
}



