#pragma once

#ifndef FW_VCR_H
#define FW_VCR_H

//#include "fw.h"
#include "fw_avcclass.h"

class BTS1394VCR : public PAVCVCR
{
public:
					BTS1394VCR(const int fd, const uint32 nodeHi, const uint32 nodeLo, const int8 subunitid);
					
	// Inherited from PAVCCommon
	virtual status_t	PowerOn();
	virtual status_t	PowerOff();
	virtual status_t	Reserve(const unsigned char prio, const char *text);
	virtual status_t	VendorDependent(const int32 companyid, char *data, int32 &size);
	
	virtual status_t	GetPlugInfo(uint32 pluginfo);
	virtual status_t	GetPowerState(uint8 &);
	virtual status_t	GetReserveState(char *buff, const uint8 size);


	/*	Setting Various Parameters */
	virtual status_t	SetAnalogAudioOutMode(const uint8 mode);
	virtual status_t	SetAbsoluteTrackNumber(const uint32);
	virtual status_t	SetAudioMode(const int32, const int32, const int32);
	virtual status_t	SetEditMode(const uint8 mode);
	virtual status_t	SetInputSignalMode(const uint8 mode);
	virtual status_t	SetOutputSignalMode(const uint8 mode);
	virtual status_t	SetPreset(const uint8 param, const uint32 value);
	virtual status_t	SetRecordingSpeed(const uint8 speed);

	/* Transport commands */
	virtual status_t	Backward(const uint8 units, const uint8 count);
	virtual status_t	Forward(const uint8 units, const uint8 count);
	virtual status_t	LoadMedium(const uint8);
	virtual status_t	Play(const uint8);
	virtual status_t	Record(const uint8);
	virtual status_t	Stop();
	virtual status_t	Pause();
	virtual status_t	Wind(const uint8);
	virtual status_t	GotoTimeCode(const uint8, const uint8, const uint8, const uint8);
	virtual status_t	OpenMemory(const uint8);
	virtual status_t	ReadMemory(const uint8, const uint16, char *buffer);
	virtual status_t	WriteMemory(const uint8, const uint16, char *buffer);

	/* Getting the state of things */
	virtual status_t	GetAnalogAudioOutMode(uint8 &);
	virtual status_t	GetAbsoluteTrackNumber(uint8 &);
	virtual status_t	GetAudioMode();
	virtual status_t	GetEditMode();
	virtual status_t	GetInputSignalMode();
	virtual status_t	GetMediumInfo();
	virtual status_t	GetOutputSignalMode();
	virtual status_t	GetPreset(const uint8, int32 &);
	virtual status_t	GetRecordingDate(uint32 &);
	virtual status_t	GetRecordingSpeed(uint8 &);
	virtual status_t	GetRecordingTime(uint32 &);
	virtual status_t	GetSearchMode(uint8 &, uint32 &);
	virtual status_t	GetCurrentTimeCode(uint8 &frame, uint8 &second, uint8 &minute, uint8 &hour);
	virtual status_t	GetTransportState(uint8 &mode, uint8 &state);	
	virtual status_t	GetOpenMemory(uint8 &);

protected:
			status_t	DoControl(const uint8 command, const uint8 param);
			
	int fID;
	uint32	fNodeHi;
	uint32	fNodeLo;
	uint8	fSubUnitID;
//	HA_1394IO_CONTROL 	*asynctl;
//	FW_BUFFER			a1,async1;
//	uint32				*asyncbuffer;

private:
//	BTS1394VCR();	// Make this private so it can't be used
//	BTS1394VCR(const BTS1394VCR &);
};

#endif
