#pragma once

#include "fw_vcr.h"
#include "fw_avc.h"
#include "fw.h"
#include "fw_opt.h"

#include <stdio.h>
#include <fcntl.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

static HA_1394IO_CONTROL 	*asynctl;
static FW_BUFFER			a1,async1;
static unsigned long		*asyncbuffer;

BTS1394VCR::BTS1394VCR(const int fd, const uint32 nodeHi, const uint32 nodeLo, const int8 subunitid)
{
	fID = fd;
	fNodeHi = nodeHi;
	fNodeLo = nodeLo;
	fSubUnitID = subunitid;
	
	if (fID > -1)
	{
printf("BTSVCRHandler::BTSVCRHandler Driver ID: %d\n", fID);
		a1.buffer_size = BUFFER_SIZE8K;
		status_t status = ioctl(fID,FW_ALLOCATE_BUFFER,&a1);
		asynctl = (HA_1394IO_CONTROL *)a1.buffer_address;
printf("BTSVCRHandler::BTSVCRHandler - status %d\n",status);

		async1.buffer_size = BUFFER_SIZE8K;
		status = ioctl(fID,FW_ALLOCATE_BUFFER,&async1);
		asyncbuffer = (unsigned long *)async1.buffer_address;
printf("BTSVCRHandler::BTSVCRHandler - asyncbuffer status %d\n",status);
	}

}

status_t	BTS1394VCR::DoControl(const uint8 command, const uint8 param)
{
	printf("BTS1394VCR::DoControl - Command (%d) (0x%x)\n", command, param);
	asyncbuffer[0]=MKAVCCMD(AVC_CTYPE_CONTROL,AVC_SUBUNIT_TYPE_VCR,fSubUnitID,command,param);
	printf("BTS1394VCR::DoControl - %x\n", asyncbuffer[0]);
	csr_write(0xf0000b00,asyncbuffer,fNodeHi,fNodeLo,asynctl,fID);				
}

// Inherited from PAVCCommon
status_t	BTS1394VCR::PowerOn()
{
}

status_t	BTS1394VCR::PowerOff()
{
}

status_t	BTS1394VCR::Reserve(const unsigned char prio, const char *txt)
{
}
 
status_t	BTS1394VCR::VendorDependent(const int32 companyid, char *data, int32 &size)
{
}

	
status_t	BTS1394VCR::GetPlugInfo(uint32 pluginfo)
{
}

status_t	BTS1394VCR::GetPowerState(uint8 &)
{
}

status_t	BTS1394VCR::GetReserveState(char *buff, const uint8 size)
{
}



/*	Setting Various Parameters */
status_t	BTS1394VCR::SetAnalogAudioOutMode(const uint8 mode)
{
}

status_t	BTS1394VCR::SetAbsoluteTrackNumber(const uint32)
{
}

status_t	BTS1394VCR::SetAudioMode(const int32, const int32, const int32)
{
}

status_t	BTS1394VCR::SetEditMode(const uint8 mode)
{
}

status_t	BTS1394VCR::SetInputSignalMode(const uint8 mode)
{
}

status_t	BTS1394VCR::SetOutputSignalMode(const uint8 mode)
{
}

status_t	BTS1394VCR::SetPreset(const uint8 param, const uint32 value)
{
}

status_t	BTS1394VCR::SetRecordingSpeed(const uint8 speed)
{
}


/* Transport commands */
status_t	BTS1394VCR::Backward(const uint8 units, const uint8 count)
{
}

status_t	BTS1394VCR::Forward(const uint8 units, const uint8 count)
{
}

status_t	BTS1394VCR::LoadMedium(const uint8)
{
}

status_t	BTS1394VCR::Play(const uint8 param)
{
	printf("BTS1394::Play\n");
	return DoControl(VCR_PLAY,param);
}

status_t	BTS1394VCR::Record(const uint8 param)
{
	return DoControl(VCR_RECORD, param);
}

status_t	BTS1394VCR::Stop()
{
	return DoControl(VCR_WIND,VCR_WIND_STOP);
}

status_t	BTS1394VCR::Pause()
{
	return DoControl(VCR_PLAY,VCR_PLAY_FORWARD_PAUSE);
}

status_t	BTS1394VCR::Wind(const uint8 param)
{
	return DoControl(VCR_WIND, param);
}

status_t	BTS1394VCR::GotoTimeCode(const uint8, const uint8, const uint8, const uint8)
{
}

status_t	BTS1394VCR::OpenMemory(const uint8)
{
}

status_t	BTS1394VCR::ReadMemory(const uint8, const uint16, char *buffer)
{
}

status_t	BTS1394VCR::WriteMemory(const uint8, const uint16, char *buffer)
{
}


/* Getting the state of things */
status_t	BTS1394VCR::GetAnalogAudioOutMode(uint8 &)
{
}

status_t	BTS1394VCR::GetAbsoluteTrackNumber(uint8 &)
{
}

status_t	BTS1394VCR::GetAudioMode()
{
}

status_t	BTS1394VCR::GetEditMode()
{
}

status_t	BTS1394VCR::GetInputSignalMode()
{
}

status_t	BTS1394VCR::GetMediumInfo()
{
}

status_t	BTS1394VCR::GetOutputSignalMode()
{
}

status_t	BTS1394VCR::GetPreset(const uint8, int32 &)
{
}

status_t	BTS1394VCR::GetRecordingDate(uint32 &)
{
}

status_t	BTS1394VCR::GetRecordingSpeed(uint8 &)
{
}

status_t	BTS1394VCR::GetRecordingTime(uint32 &)
{
}

status_t	BTS1394VCR::GetSearchMode(uint8 &, uint32 &)
{
}

status_t	BTS1394VCR::GetCurrentTimeCode(uint8 &frame, uint8 &second, uint8 &minute, uint8 &hour)
{
}

status_t	BTS1394VCR::GetTransportState(uint8 &mode, uint8 &state)	
{
}

status_t	BTS1394VCR::GetOpenMemory(uint8 &)
{
}

