/*
	Copyright Be Inc. 1997  All Rights Reserved
*/

#pragma once

#ifndef FW_AVCCLASS_H
#define FW_AVCCLASS_H

#include <SupportDefs.h>

/*
	class: PAVCCommon
	
	Representation of protocol of commands that are common
	to both AV Units and subunits.
*/

class PAVCCommon
{
public:
	virtual status_t	PowerOn()=0;
	virtual status_t	PowerOff()=0;
	virtual status_t	Reserve(const unsigned char prio, const char *txt)=0;
	virtual status_t	VendorDependent(const int32 companyid, char *data, int32 &size)=0;
	
	virtual status_t	GetPlugInfo(uint32 pluginfo)=0;
	virtual status_t	GetPowerState(uint8 &)=0;
	virtual status_t	GetReserveState(char *buff, const uint8 size);
	
protected:
private:
};


/*
	class: PAVCUnit
	
	Protocol class representing commands that AV Units
	understand.
*/

class PAVCUnit
{
public:
	virtual status_t	ChannelUsage() = 0;
	virtual status_t	Connect() = 0;
	virtual status_t	Connect_AV() = 0;
	virtual status_t	Connections() = 0;
	virtual status_t	Digital_Input() = 0;
	virtual status_t	Digital_Output() = 0;
	virtual status_t	Disconnect() = 0;
	virtual status_t	Disconnect_AV() = 0;
	virtual status_t	InputPlugSigFormat() = 0;
	virtual status_t	OutputPlugSigFormat() = 0;
	virtual status_t	SubunitInfo() = 0;
	virtual status_t	UnitInfo() = 0;
	
protected:
private:
};

/*
	class: PAVCVCR
	
	Protocol class representing commands that a VCR subunit
	understands.
*/

class PAVCVCR
{
public:
	/*	Setting Various Parameters */
	virtual status_t	SetAnalogAudioOutMode(const uint8 mode)=0;
	virtual status_t	SetAbsoluteTrackNumber(const uint32)=0;
	virtual status_t	SetAudioMode(const int32, const int32, const int32)=0;
	virtual status_t	SetEditMode(const uint8 mode)=0;
	virtual status_t	SetInputSignalMode(const uint8 mode)=0;
	virtual status_t	SetOutputSignalMode(const uint8 mode)=0;
	virtual status_t	SetPreset(const uint8 param, const uint32 value)=0;
	virtual status_t	SetRecordingSpeed(const uint8 speed)=0;

	/* Transport commands */
	virtual status_t	Backward(const uint8 units, const uint8 count)=0;
	virtual status_t	Forward(const uint8 units, const uint8 count)=0;
	virtual status_t	LoadMedium(const uint8)=0;
	virtual status_t	Play(const uint8)=0;
	virtual status_t	Record(const uint8)=0;
	virtual status_t	Stop()=0;
	virtual status_t	Pause()=0;
	virtual status_t	Wind(const uint8)=0;
	virtual status_t	GotoTimeCode(const uint8, const uint8, const uint8, const uint8)=0;
	virtual status_t	OpenMemory(const uint8)=0;
	virtual status_t	ReadMemory(const uint8, const uint16, char *buffer)=0;
	virtual status_t	WriteMemory(const uint8, const uint16, char *buffer)=0;

	/* Getting the state of things */
	virtual status_t	GetAnalogAudioOutMode(uint8 &)=0;
	virtual status_t	GetAbsoluteTrackNumber(uint8 &)=0;
	virtual status_t	GetAudioMode()=0;
	virtual status_t	GetEditMode()=0;
	virtual status_t	GetInputSignalMode()=0;
	virtual status_t	GetMediumInfo()=0;
	virtual status_t	GetOutputSignalMode()=0;
	virtual status_t	GetPreset(const uint8, int32 &)=0;
	virtual status_t	GetRecordingDate(uint32 &)=0;
	virtual status_t	GetRecordingSpeed(uint8 &)=0;
	virtual status_t	GetRecordingTime(uint32 &)=0;
	virtual status_t	GetSearchMode(uint8 &, uint32 &)=0;
	virtual status_t	GetCurrentTimeCode(uint8 &frame, uint8 &second, uint8 &minute, uint8 &hour)=0;
	virtual status_t	GetTransportState(uint8 &mode, uint8 &state)=0;	
	virtual status_t	GetOpenMemory(uint8 &)=0;

protected:
private:
};

#endif
