/*
	Copyright Be Inc. 1997  All Rights Reserved
*/

#pragma once

#ifndef FW_AVC_H
#define FW_AVC_H

/*
	Constants that are used for FireWire command implementation
*/
/*
	AV/C - Unit Commands
*/

#define AVC_CHANNEL_USAGE			(0x12)
#define AVC_CONNECT					(0x24)
#define AVC_CONNECT_AV				(0x20)
#define AVC_CONNECTIONS				(0x22)
#define AVC_DIGITAL_INPUT			(0x11)
#define AVC_DIGITAL_OUTPUT			(0x10)
#define AVC_DISCONNECT				(0x25)
#define AVC_DISCONNECT_AV			(0x21)
#define AVC_INPUT_PLUG_SIG_FORMAT	(0x19)
#define AVC_OUTPUT_PLUG_SIG_FORMAT	(0x18)
#define AVC_SUBUNIT_INFO			(0x31)
#define AVC_UNIT_INFO				(0x30)

/*
	Commands that are applicable to an AV unit as
	well as a subunit independent of the functionality
	that these subunits represent indicated by their
	subunit_type.
*/
#define AVC_COMMON_POWER			0xB2
	#define AVC_COMMON_POWER_ON		0x70
	#define AVC_COMMON_POWER_OFF	0x60
	#define AVC_COMMON_POWER_STATUS 0x7F
#define AVC_COMMON_RESERVE			(0x01)
#define AVC_COMMON_PLUG_INFO		(0x02)
#define AVC_COMMON_VENDOR_DEPENDENT (0x00)

/*
	VCR - Subunit commands
*/

#define VCR_ANALOG_AUDIO_OUT	(0x70)
	/* Control Commands */
	#define VCR_ANALOG_MONO				0x20
	#define VCR_ANALOG_RIGHT			0x21
	#define VCR_ANALOG_AUDIO_LEFT		0x22
	#define VCR_ANALOG_AUDIO_STEREO	0x23
	#define VCR_ANALOG_AUDIO_SECONDARY	0x25
	#define VCR_ANALOG_AUDIO_MAIN		0x26
	#define VCR_ANALOG_AUDIO_BILINGUAL	0x27
	/* Status Commands */
	#define VCR_ANALOG_AUDIO_STATUS	(0xff)
	
#define VCR_ATN					(0x52)
#define VCR_AUDIO_MODE			(0x71)
	/* Audio Blocks */
	#define VCR_AUDIO_MODE_CH1	0x00
	#define VCR_AUDIO_MODE_CH2	0x01
	#define VCR_AUDIO_MODE_CH3	0x02
	#define VCR_AUDIO_MODE_CH4	0x03
	/* Audio block active */
	#define VCR_AUDIO_MODE_RECORD			0x00
	#define VCR_AUDIO_MODE_NO_RECORD		0x01
	#define VCR_AUDIO_MODE_RESERVED		0x02
	#define VCR_AUDIO_MODE_DONT_CARE		0x03
	/* Audio Channels */
	#define VCR_AUDIO_MODE_ONE_CHANNEL		0x00
	#define VCR_AUDIO_MODE_TWO_CHANNEL		0x01
	#define VCR_AUDIO_MODE_20BIT			0x02
	/* Audio Frequencies */
	#define VCR_AUDIO_MODE_48	0x00
	#define VCR_ADUIO_MODE_44	0x01
	#define VCR_AUDIO_MODE_32	0x02
	
#define VCR_BACKWARD			0x56
	#define VCR_BACKWARD_FRAME	0x00
	#define VCR_BACKWARD_SCENE	0x01
	
#define VCR_EDIT_MODE			0x40
	#define VCR_EDIT_PREROLL					(0x00)
	#define VCR_EDIT_VID_INSERT_SYNC_RECORD	(0x21)
	#define VCR_EDIT_AUD_INSERT_SYNC_RECORD	(0x22)
	#define VCR_EDIT_AV_INSERT_SYNC_RECORD		(0x23)
	#define VCR_EDIT_SUB_INSERT_SYNC_RECORD	(0x24)
	#define VCR_EDIT_SYNC_RECORD				(0x25)
	#define VCR_EDIT_SYNC_PLAY					(0x35)

#define VCR_FORWARD				(0x55)
#define VCR_INPUT_SIGNAL_MODE	(0x79)
	#define VCR_SIGNAL_MODE_SD525-60	(0x00)
	#define VCR_SIGNAL_MODE_SDL525-60	(0x04)
	#define VCR_SIGNAL_MODE_HD1125-60	(0x08)
	#define VCR_SIGNAL_MODE_SD625-50	(0x80)
	#define VCR_SIGNAL_MODE_SDL625-50	(0x84)
	#define VCR_SIGNAL_MODE_HD1250-50	(0x88)
	
#define VCR_LOAD_MEDIUM					(0xC1)
	#define VCR_LOAD_MEDIUM_EJECT		(0x60)
	#define VCR_LOAD_MEDIUM_OPEN_TRAY	(0x31)
	#define VCR_LOAD_MEDIUM_CLOSE_TRAY	(0x32)
	
#define VCR_MEDIUM_INFO					(0xDA)
#define VCR_OPEN_MIC					(0x60)
	#define VCR_OPEN_MIC_CLOSE			(0x00)
	#define VCR_OPEN_MIC_READ_OPEN		(0x01)
	#define VCR_OPEN_MIC_WRITE_OPEN	(0x03)

#define VCR_OUTPUT_SIGNAL_MODE			((uint8)0x78)
#define VCR_PLAY						((uint8)0xc3)
	#define VCR_PLAY_NEXT_FRAME			0x30
	#define VCR_PLAY_SLOWEST_FOWARD	0x31
	#define VCR_PLAY_SLOW_FORWARD6		0x32
	#define VCR_PLAY_SLOW_FORWARD5		0x33
	#define VCR_PLAY_SLOW_FORWARD4		0x34
	#define VCR_PLAY_SLOW_FORWARD3		0x35
	#define VCR_PLAY_SLOW_FORWARD2		0x36
	#define VCR_PLAY_SLOW_FORWARD1		0x37
	#define VCR_PLAY_X1					0x38
	#define VCR_PLAY_FAST_FORWARD1		0x39
	#define VCR_PLAY_FAST_FORWARD2		0x3A
	#define VCR_PLAY_FAST_FORWARD3		0x3B
	#define VCR_PLAY_FAST_FORWARD4		0x3C
	#define VCR_PLAY_FAST_FORWARD5		0x3D
	#define VCR_PLAY_FAST_FORWARD6		0x3E
	#define VCR_PLAY_FASTEST_FORWARD	0x3F
	#define VCR_PLAY_PREVIOUS_FRAME	0x40
	#define VCR_PLAY_SLOWEST_REVERSE	0x41
	#define VCR_PLAY_SLOW_REVERSE6		0x42
	#define VCR_PLAY_SLOW_REVERSE5		0x43
	#define VCR_PLAY_SLOW_REVERSE4		0x44
	#define VCR_PLAY_SLOW_REVERSE3		0x45
	#define VCR_PLAY_SLOW_REVERSE2		0x46
	#define VCR_PLAY_SLOW_REVERSE1		0x47
	#define VCR_PLAY_X1_REVERSE			0x48
	#define VCR_PLAY_FAST_REVERSE1		0x49
	#define VCR_PLAY_FAST_REVERSE2		0x4A
	#define VCR_PLAY_FAST_REVERSE3		0x4B
	#define VCR_PLAY_FAST_REVERSE4		0x4C
	#define VCR_PLAY_FAST_REVERSE5		0x4D
	#define VCR_PLAY_FAST_REVERSE6		0x4E
	#define VCR_PLAY_FASTEST_REVERSE	0x4F
	#define VCR_PLAY_REVERSE			0x65
	#define VCR_PLAY_REVERSE_PAUSE		0x6D
	#define VCR_PLAY_FORWARD			0x75
	#define VCR_PLAY_FORWARD_PAUSE		0x7D
	
#define VCR_PRESET				(0x45)
#define VCR_READ_MIC			(0x61)
#define VCR_RECORD				(0xC2)
	#define VCR_RECORD_VIDEO_INSERT	0x31
	#define VCR_RECORD_AUDIO_INSERT	0x32
	#define VCR_RECORD_AV_INSERT		0x33
	#define VCR_RECORD_SUBCODE_INSERT	0x34
	#define VCR_RECORD_VIDEO_INSERT_PAUSE	0x41
	#define VCR_RECORD_AUDIO_INSERT_PAUSE	0x42
	#define VCR_RECORD_AV_INSERT_PAUSE		0x43
	#define VCR_RECORD_SUBCODE_INSERT_PAUSE	0x44
	#define VCR_RECORD_RECORD			0x75
	#define VCR_RECORD_RECORD_PAUSE	0x7D
	
#define VCR_RECORDING_DATE		(0x53)
#define VCR_RECORDING_SPEED		(0xDB)
	#define VCR_RECORDING_SPEED_SPEED32	0x20
	#define VCR_RECORDING_SPEED_STANDARD	0x6F
	
#define VCR_RECORDING_TIME		(0x54)
#define VCR_SEARCH_MODE			(0x50)
#define VCR_TIME_CODE			(0x51)
#define VCR_TRANSPORT_STATE		(0xD0)
#define VCR_WIND				(0xC4)
	#define VCR_WIND_HIGH_SPEED_REWIND	(0x45)
	#define VCR_WIND_STOP		(0x60)
	#define VCR_WIND_REWIND		(0x65)
	#define VCR_WIND_FAST_FORWARD	(0x75)
#define VCR_WRITE_MIC			(0x62)


/* CTYPE - Command Type */
#define AVC_CTYPE_CONTROL		(0x00)
#define AVC_CTYPE_STATUS		(0x01)
#define AVC_CTYPE_INQUIRY		(0x02)
#define AVC_CTYPE_NOTIFY		(0x03)

/* Response Code */
#define AVC_RESPONSE_NOT_IMPLEMENTED	(0x08)
#define AVC_RESPONSE_ACCEPTED			(0x09)
#define AVC_RESPONSE_REJECTED			(0x0A)
#define AVC_RESPONSE_IN_TRANSITION		(0x0B)
#define AVC_RESPONSE_IMPLEMENTED		(0x0C)
#define AVC_RESPONSE_CHANGED			(0x0D)
#define AVC_RESPONSE_RESERVED			(0x0E)
#define AVC_RESPONSE_INTERIM			(0x0F)

/* Subunit Type */
#define AVC_SUBUNIT_TYPE_VIDMONITOR	(0x00)
#define AVC_SUBUNIT_TYPE_RESERVED1		(0x01)
#define AVC_SUBUNIT_TYPE_RESERVED2		(0x02)
#define AVC_SUBUNIT_TYPE_RESERVED3		(0x03)
#define AVC_SUBUNIT_TYPE_VCR			(0x04)
#define AVC_SUBUNIT_TYPE_TVTUNER		(0x05)
#define AVC_SUBUNIT_TYPE_RESERVED4		(0x06)
#define AVC_SUBUNIT_TYPE_VIDCAMERA		(0x07)
#define AVC_SUBUNIT_TYPE_VENDORUNIQUE	(0x1C)
#define AVC_SUBUNIT_TYPE_UNIT			(0x1F)

/*
	Helper macros for making commands from the various
	bits.
	
	An AV/C command looks like this:
	
	0000[4] ctype[4] subunit_type[5] subunit_id[3] opcode[8] operand0[8]
	
	The number within the brackets indicates the number
	of bits used to encode that part of the command.  The 
	following macros do the basic bit shifting to get things into 
	the right places.
	
*/

#define MKAVCCMD(ctype,subtype,subid,opcode,operand)	\
	((unsigned long)(ctype<<24|subtype<<19|subid<<16|opcode<<8|operand))

#endif
