/*
	
	PCIListView.cpp
	
	Copyright 1995 Be Incorporated, All Rights Reserved.
	
*/

#include "PCIListView.h"
#include "PCIListItem.h"
#include "PCIDeviceView.h"

#include <OutlineListView.h>
#include <ListItem.h>
#include <PCI.h>
#include <ScrollView.h>


typedef struct 
{
	char *class_name;
	int class_base;
} pci_class_list;

pci_class_list CLASSLIST[] = 
{
	"Base Peripheral",PCI_base_peripheral,
	"Bridge",PCI_bridge,
	"Display",PCI_display,
	"Docking Station",PCI_docking_station,
	"Early",PCI_early,
	"Input",PCI_input,
	"Mass Storage", PCI_mass_storage,
	"Memory",PCI_memory,
	"Multimedia",PCI_multimedia,
	"Network",PCI_network,
	"Processor",PCI_processor,
	"Serial Bus",PCI_serial_bus,
	"Simple Communications",PCI_simple_communications,
	"Undefined",PCI_undefined
};
int CLASSLISTSIZE = 14;



static long CountDeviceClass(uint8 class_base)
{
	int aIndex = 0;
	int numItems=0;
	pci_info info;
	status_t status;
	
	for (aIndex=0; ; aIndex++)
	{
	 	status = get_nth_pci_info(aIndex, &info);
	 	//printf("CountDeviceClass: %d  %d   %d\n", status, class_base, info.class_base);
	 	if (status != B_NO_ERROR)
	 		break;

		if (info.class_base == class_base)
			numItems++;
	}
	
	return numItems;
}

static long FillDeviceClass(BOutlineListView *aList, BStringItem *parent, uint8 class_base)
{
	BStringItem *item;
	pci_info	info;
	int aIndex = 0;
	long numSelected = 0;
	
	for (aIndex=0; ; aIndex++)
	{
	 	if (get_nth_pci_info(aIndex, &info) != B_NO_ERROR)
	 		break;
		
		if (info.class_base != class_base)
			continue;
		
		item = new BTSPCIListItem(info);
		aList->AddUnder(item,parent);

		numSelected++;
		
	}
	
	if (numSelected > 0)
		parent->SetEnabled(false);
		
	return numSelected;
}

static void FillDeviceList(BOutlineListView *aList)
{
	BStringItem *item;
	
	// If the item is a leaf item, if you don't have it
	// initially open, it will not show up.
	for (int i = 0; i < CLASSLISTSIZE; i++)
	{
		if (CountDeviceClass(CLASSLIST[i].class_base) > 0)
		{
			item = new BStringItem(CLASSLIST[i].class_name,1,true);
			aList->AddItem(item);
			FillDeviceClass(aList, item, CLASSLIST[i].class_base);
		}
	}
}

PCIListView::PCIListView(BRect rect, char *name)
	   	   : BView(rect, name, B_FOLLOW_ALL, B_FULL_UPDATE_ON_RESIZE|B_WILL_DRAW|B_FRAME_EVENTS)
{
	BRect aRect(rect);
	aRect.OffsetTo(B_ORIGIN);
	aRect.right = aRect.left+180;
	
	BRect deviceRect(rect);
	deviceRect.left = 181+18;	// left margin + scroll width
	fDeviceView = new BTSPCIDeviceView(deviceRect, "deviceview");

	fOutlineView = new BOutlineListView(aRect,name,B_SINGLE_SELECTION_LIST,
		B_FOLLOW_ALL, B_WILL_DRAW);
	fOutlineView->SetInvocationMessage(new BMessage(MSG_DISPLAYPCI));
	fOutlineView->SetSelectionMessage(new BMessage(MSG_DISPLAYPCI));
	
	FillDeviceList(fOutlineView);
	fOutlineView->SetViewColor(213,213,255);
	fOutlineView->SetHighColor(0,0,0);
	fOutlineView->SetLowColor(213,213,255);
	
	// Create a scroll area.  We give it a fixed size
	// because we need to fit stuff to the right.
	BRect scrollRect(rect);
	scrollRect.right = scrollRect.left + 180;

	// Note the resize flags.  You have to use B_FOLLOW_TOP_BOTTOM,
	// Using B_FOLLOW_TOP|B_FOLLOW_BOTTOM will not give you the
	// desired result.
	fScrollView = new BScrollView("scroll_view",fOutlineView,
							B_FOLLOW_TOP_BOTTOM,
							0,false,true, B_FANCY_BORDER);

	
	AddChild(fScrollView);
	AddChild(fDeviceView);
	SetViewColor(113,0,0);
}

void
PCIListView::AttachedToWindow()
{
	// In order to set the target, we need to be attached
	// to a looper, so it is easier to do it here rather
	// than in the constructor
	fOutlineView->SetTarget(this);
	fOutlineView->Select(1);
	fOutlineView->MakeFocus();

}

void
PCIListView::Draw(BRect updateRect)
{
	SetHighColor(113,0,0);
	FillRect(updateRect);
}

void
PCIListView::MessageReceived(BMessage *msg)
{
	switch (msg->what)
	{
		case MSG_DISPLAYPCI:
			int32 current = fOutlineView->CurrentSelection();
			if (current < 0)
				break;
				
				BTSPCIListItem *item = dynamic_cast<BTSPCIListItem *>
						(fOutlineView->ItemAt(current));
				if (item)
				{
					pci_info info;
					item->GetInfo(info);
					fDeviceView->SetDevice(info);
				}
		break;
		
		default:
			inherited::MessageReceived(msg);
		break;
	}
}
