#include "PCIListItem.h"
#include "pci_code.h"

/*
	BTSPCIListItem

	Construct a list item using the pci_info structure.
	This will allow us to display a pci_info ultimately.
*/

BTSPCIListItem::BTSPCIListItem(pci_info &info)
	: BStringItem("dummy"),
	fInfo(info)
{
	// Get the string representations of the vendor
	// and chip ids if possible.
	char *chipPtr = FindPCIDeviceString(info.vendor_id, info.device_id);
	char *vendPtr = FindPCIVendorString(info.vendor_id);
	
	if (vendPtr)
		strcpy(fvendbuff, vendPtr);
	else
		sprintf(fvendbuff,"Unknown: %x", (int)info.vendor_id);
		
	if (chipPtr)
		strcpy(fchipbuff, chipPtr);
	else
		sprintf(fchipbuff,"Device: %x", (int)info.device_id);
};

/*
	Method: Update()
	
	This method is called whenever the outside world changes
	the font and view that we will be displayed into.  We want
	to control our height and width from here.  In our case, we
	want the cell to be twice as high as the fontHeight since we
	display two lines of text.
*/

void 
BTSPCIListItem::Update(BView *owner, const BFont *font)
{
	SetWidth(100);

	font_height finfo;
	font->GetHeight(&finfo);
	fFontHeight = finfo.ascent + finfo.descent + finfo.leading;
	fBaselineOffset = finfo.descent;
	SetHeight(fFontHeight*2+3);
}

// This is an undocumented funtion that will probably go away.
// It allows you to shift a color by a specified amount.
extern rgb_color shift_color(rgb_color c, float percent);

/*
	Method: DrawItem 

	The framework calls this method automatically when it's time
	to do some drawing.  We are totally responsible for drawing ourself
	in both the selected and non-selected states.  Making a call
	to IsSelected() will tell us the current state.
*/

void		
BTSPCIListItem::DrawItem(BView *owner,BRect bounds, bool complete)
{
	
	BPoint where = bounds.LeftTop();
	where.x += 4;
	where.y += fFontHeight-3;


	rgb_color	h = owner->HighColor();
	rgb_color	low = owner->LowColor();
	rgb_color	bkg = low;

	if (IsSelected() || complete) 
	{
		if (IsSelected()) 
		{
			bkg = shift_color(low, 1.30);
			owner->SetLowColor(bkg);		// for anti-aliasing text
		}
	}
	
	owner->SetHighColor(bkg);
	owner->FillRect(bounds);
	owner->SetHighColor(h);
	owner->StrokeRect(bounds);
	
	if (!IsEnabled())
		owner->SetHighColor(shift_color(h, 0.5));

	// Draw the vendor string
	owner->MovePenTo(where);
	owner->SetDrawingMode(B_OP_COPY);
	owner->DrawString(fvendbuff);
	
	// Draw the device string
	where.y += fFontHeight+3;
	owner->MovePenTo(where);
	owner->DrawString(fchipbuff);

	if (!IsEnabled())
		owner->SetHighColor(h);

	if (IsSelected())
		owner->SetLowColor(low);
}

