/*
	
	PCIList.cpp
	
	Copyright 1997 Be Incorporated, All Rights Reserved.
	
*/

#include "PCIList.h"
#include "PCIListView.h"
#include "PCIListWindow.h"

main()
{	
	PCIListApplication *myApplication;

	myApplication = new PCIListApplication();
	myApplication->Run();
	
	delete(myApplication);
	return(0);
}

PCIListApplication::PCIListApplication()
		  		  : BApplication("application/PCIList")
{
	PCIListWindow		*aWindow;
	PCIListView		*aView;
	BRect			aRect;

	// set up a rectangle and instantiate a new window
	aRect.Set(10, 30, 630, 450);
	aWindow = new PCIListWindow(aRect);
	
	// set up a rectangle and instantiate a new view
	// view rect should be same size as window rect but with left top at (0, 0)
	aRect.OffsetTo(B_ORIGIN);
	aView = new PCIListView(aRect, "PCIListView");
	
	// add view to window
	aWindow->AddChild(aView);
	
	// make window visible
	aWindow->Show();
}
