/*
	
	ButtonWorld.cpp
	Copyright 1997 Be Incorporated, All Rights Reserved.
	
*/
#include "ButtonWindow.h"
#include "ButtonWorld.h"

main()
{	
	// Create an application instance
	ButtonApplication myApplication;
	
	// Run the application looper
	myApplication.Run();

	return(0);
}

// ButtonApplication constructor
ButtonApplication::ButtonApplication()
		  		  : BApplication("application/x-vnd.Be-ButtonWorldSample")
{
	BRect			aRect;

	// set up a rect and instantiate a new window
	aRect.Set(200, 200, 400, 300);
	buttonWindow = new ButtonWindow(aRect);
		
	// make window visible
	buttonWindow->Show();
}

// ButtonApplication::RefsReceived overiding BApplication::RefsReceived
void ButtonApplication::RefsReceived(BMessage *message) 
{ 
    entry_ref ref;
    
	// get the ref from the message
    if ( message->FindRef("refs", &ref) == B_OK ){
        
        // Make a new message
        BMessage aMessage( B_SIMPLE_DATA );
        
        // Copy the ref into it
        aMessage.AddRef( "refs", &ref );
        
		// Print the message to see its contents
		aMessage.PrintToStream();
		
		//Lock the window before calling ChildAt()  
        buttonWindow->Lock();
        BView *view = buttonWindow->ChildAt(0);
		//Unlock the window before calling PostMessage()
        buttonWindow->Unlock();
        // Post the message via the window
       	buttonWindow->PostMessage( &aMessage, view );
    }
}