#include "yagstst.h"

void
TestQuad(screen_info scrInfo,const BRect frame)
{
	unsigned char aColor=0;
	U16 width = frame.Width()-1;
	U16 height = frame.Height()-1;
	
	// Clear the area to black
	Y2DRectFill(scrInfo,frame.left,frame.top,frame.right, frame.bottom,0);
	
	
	// Do some random triangles
	double newtime = 0.0;
	double lasttime = system_time();
	double interval = 0.0;
	
	for (int looper = 0; looper < 1024; looper++)
	{
		U16 x1 = frame.left+rand()%width;
		U16 y1 = frame.top+rand()%height;
		U16 x2 = frame.left+rand()%width;
		U16 y2 = frame.top+rand()%height;
		U16 x3 = frame.left+rand()%width;
		U16 y3 = frame.top+rand()%height;
		U16 x4 = frame.left+rand()%width;
		U16 y4 = frame.top+rand()%height;
		
		Y2DQuadFill(scrInfo,
			x1, y1,
			x2, y2,
			x3, y3,
			x4, y4,
			rand()%255);
			
	}	
}

long
TestQuadThread(void *data)
{
	testParam *tparam = (testParam*)data;
	
	TestQuad(tparam->fScreenInfo, tparam->fFrame);
	
	return 0;
}


