#include "yagstst.h"

void
TestCircle(AYAGSScreen* graphdev, const U16 left, const U16 top,
	const U16 width, const U16 height)
{
	unsigned char aColor=0;
	U16 minor = Y2DMIN(width/2,height/2);
	U16 right = left + width - 1;
	U16 bottom = top + height - 1;
		
	// Clear the screen to black
	graphdev->RectFill(left,top,right, bottom,0);
	
	for (int looper=0; looper < 4; looper++)
	{
		for (int radius = 4; radius<minor-8; radius+=4)
		{
			graphdev->Circle(left+width/2,top+height/2, radius, 0);
			graphdev->Circle(left+width/2,top+height/2, radius+1, 0);
			graphdev->Circle(left+width/2,top+height/2, radius+2, 0);
			graphdev->Circle(left+width/2,top+height/2, radius+3, 0);

			graphdev->Circle(left+width/2,top+height/2, radius+4,radius*(height/2)%256);
			graphdev->Circle(left+width/2,top+height/2, radius+5,radius*(height/2)%256);
			graphdev->Circle(left+width/2,top+height/2, radius+6,radius*(height/2)%256);
			graphdev->Circle(left+width/2,top+height/2, radius+7,radius*(height/2)%256);
		}
		

		for (int radius = minor-1; radius > 8;  radius-=4)
		{
			graphdev->Circle(left+width/2,top+height/2, radius, 0);
			graphdev->Circle(left+width/2,top+height/2, radius-1, 0);
			graphdev->Circle(left+width/2,top+height/2, radius-2, 0);
			graphdev->Circle(left+width/2,top+height/2, radius-3, 0);

			graphdev->Circle(left+width/2,top+height/2, radius-4,radius*(height/2)%256);
			graphdev->Circle(left+width/2,top+height/2, radius-5,radius*(height/2)%256);
			graphdev->Circle(left+width/2,top+height/2, radius-6,radius*(height/2)%256);
			graphdev->Circle(left+width/2,top+height/2, radius-7,radius*(height/2)%256);
		}
	}
	
	for (int radius=3; radius < minor; radius++)
	{
		graphdev->Circle(left+width/2,top+height/2,radius,radius*minor%256);
	}
}

long
TestCircleThread(void *data)
{
	testParam *tparam = (testParam*)data;
	
	TestCircle(tparam->fScreenInfo, tparam->fFrame.left,tparam->fFrame.top,
		tparam->fFrame.Width(),tparam->fFrame.Height());
	
	return 0;
}


