#include "random.h"
#include <limits.h>
#include <math.h>

static const long A = 48271L;
static const long M = 2147483647L;
static const long Q = M/A;
static const long R = M%A;

// Uniform distributions
U32 	
Random::RandomLong()
{
	long TmpSeed = A*(fSeed%Q) - R * (fSeed/Q);
	if (TmpSeed >= 0)
		fSeed = TmpSeed;
	else
		fSeed = TmpSeed + M;
	
	return fSeed;
}

double	
Random::RandomReal()
{
	return (RandomLong() / ULONG_MAX);
}

long
Random::RandLong(long low, long high)
{
	unsigned long diff = high - low;
	return (low + RandomReal()*diff);
}

	
// Non-uniform distributions
U32 
Random::Poisson(double expectedVal)
{
	double Limit = exp(-expectedVal);
	double Product = RandomReal();
	
	int Count;
	for (Count = 0; Product > Limit; Count++)
		Product *= RandomReal();
		
	return Count;
}

double	
Random::NegExp(double expectedVal)
{
	return - expectedVal * log(RandomReal());
}

