#ifndef OMAR_H
#define OMAR_H

/*

*/

class ARect
{
public:
			ARect(){};
			ARect(const left, const short top,
				const short right, const short bottom) 
				{
					fLeft = left;
					fTop = top;
					fRight = right;
					fBottom = bottom;
				}

	// Standard Computations
	short Width() {return(fRight - fLeft);}
	short Height() {return(fBottom - fTop);}
	
	short fLeft;
	short fTop;
	short fRight;
	short fBottom;
	
protected:

private:

};

class ABitmap
{
public:
	// Default Constructor, you must fill things in 
	ABitmap()
		:bits(0),width(0),height(0),
		bytes_per_row(0),format(0){};
	
	// Construct a pixel_buffer from a screen_info
	ABitmap(const screen_info scrInfo) 
		: width(scrInfo.frame.Width()),
		height(scrInfo.frame.Height()),
		bytes_per_row(scrInfo.bytes_per_row),
		model(scrInfo.mode){};

	// Construct a pixel_buffer from a BBitmap
	ABitmap(const BBitmap bitmap) 
		: width(bitmap.Bounds().Width()),
		height(bitmap.Bounds().Height()),
		bytes_per_row(bitmap.BytesPerRow()),
		model(bitmap.ColorSpace()){};
		
	// Construct a pixel_buffer from scratch
	
	// Assign a pixel buffer to another pixel buffer
	
	void		*bits;
	U32	width;
	U32	height;
	U32	bytes_per_row;	
	int	format;

protected:
private:
};



class ACanvas
{
public:
			ACanvas(ABitmap *bitmap);
	virtual	~ACanvas() {};
	
	// Set default drawing color
	virtual	void	SetColor8(U08 color) = 0;
	virtual void	SetColor15(U16 color) = 0;
	virtual void	SetColor24(U32 color) = 0;
	virtual void	SetColorNative(U32 color) = 0;
	
	// Get default drawing color
	virtual U08	GetColor8() = 0;
	virtual U16	GetColor15()=0;
	virtual U32	GetColor24()=0;
	virtual U32	GetColorNative()=0;
	
	ABitmap	fBitmap;
	ARect	fClipRect;
	
protected:

private:

};

extern ACanvas *gScreenCanvas;

#endif

