#ifndef BESPECIFIC_YGTYPES_H
#define BESPECIFIC_YGTYPES_H

#include <InterfaceDefs.h>
#include <Bitmap.h>

typedef unsigned char	U08;
typedef unsigned short	U16;
typedef unsigned long	U32;
 
typedef enum 
{ 
	YG_MONOCHROME_1_BIT = 1,
	YG_GRAYSCALE_8_BIT = 2,
	YG_COLOR_8_BIT = 4,
	YG_RGB_24_BIT = 8 
} color_model;


//
// 2D Point definitions
//
typedef struct Point2Ds
{
	U16 x;
	U16 y;
} Point2Ds;

typedef struct Point2Dl 
{
	U32 x;
	U32 y;
} Point2Dl;

typedef struct Point2Df 
{
	float x;
	float y;
} Point2Df;


const int kMaxCtrlPoints = 12;

typedef Point2Df BezArray[kMaxCtrlPoints];


//
// Matrix definitions
//
typedef float matrix_3x3f[3][3];

typedef float matrix_4x4f[4][4];	// 4x4 homogenous matrix

typedef float matrix_1x4f[4];		// a row vector

//
// Pixel buffer definitions
//

typedef struct pixel_buffer
{
/*
public:
		pixel_buffer();
		pixel_buffer(const int width, const int height, const long mode=0);
		~pixel_buffer();
		
		void PutPixel(const int x, const int y, const unsigned char pixval);
		void draw_y_line(const int x,const int ystart,
						const int yend,const int col);
*/

	long mode;
	U32 bytes_per_row;
	U32 x;
	U32 y;
	U32 width;
	U32 height;
	void *pixels;
} pixel_buffer;

/*
typedef struct pixel_buffer
{
	void *bits;
	U32	width;
	U32	height;
	U32	bytes_per_row;	
	int	model;

	// Construct a pixel_buffer from a screen_info
	pixel_buffer(const screen_info scrInfo) 
		: width(scrInfo.frame.Width()),
		height(scrInfo.frame.Height()),
		bytes_per_row(scrInfo.bytes_per_row),
		model(scrInfo.mode){};

	// Construct a pixel_buffer from a BBitmap
	pixel_buffer(const BBitmap bitmap) 
		: width(bitmap.Bounds().Width()),
		height(bitmap.Bounds().Height()),
		bytes_per_row(bitmap.BytesPerRow()),
		model(bitmap.ColorSpace()){};
		
	// Construct a pixel_buffer from scratch
	
	// Assign a pixel buffer to another pixel buffer
} pixel_buffer;
*/

#endif
