#include "yags3d.h"

void
Mat4x4_Mul4x4(const matrix_4x4f a, const matrix_4x4f b,
	matrix_4x4f res)
{
	// First row
	res[0][0]=a[0][0]*b[0][0]+a[0][1]*b[1][0]+a[0][2]*b[2][0]+a[0][3]*b[3][0];
	res[0][1]=a[0][0]*b[0][1]+a[0][1]*b[1][1]+a[0][2]*b[2][1]+a[0][3]*b[3][1];
	res[0][2]=a[0][0]*b[0][2]+a[0][1]*b[1][2]+a[0][2]*b[2][2]+a[0][3]*b[3][2];
	res[0][3]=a[0][0]*b[0][3]+a[0][1]*b[1][3]+a[0][2]*b[2][3]+a[0][3]*b[3][3];

	// second row
	res[1][0]=a[1][0]*b[0][0]+a[1][1]*b[1][0]+a[1][2]*b[2][0]+a[1][3]*b[3][0];
	res[1][1]=a[1][0]*b[0][1]+a[1][1]*b[1][1]+a[1][2]*b[2][1]+a[1][3]*b[3][1];
	res[1][2]=a[1][0]*b[0][2]+a[1][1]*b[1][2]+a[1][2]*b[2][2]+a[1][3]*b[3][2];
	res[1][3]=a[1][0]*b[0][3]+a[1][1]*b[1][3]+a[1][2]*b[2][3]+a[1][3]*b[3][3];

	// third row
	res[2][0]=a[2][0]*b[0][0]+a[2][1]*b[1][0]+a[2][2]*b[2][0]+a[2][3]*b[3][0];
	res[2][1]=a[2][0]*b[0][1]+a[2][1]*b[1][1]+a[2][2]*b[2][1]+a[2][3]*b[3][1];
	res[2][2]=a[2][0]*b[0][2]+a[2][1]*b[1][2]+a[2][2]*b[2][2]+a[2][3]*b[3][2];
	res[2][3]=a[2][0]*b[0][3]+a[2][1]*b[1][3]+a[2][2]*b[2][3]+a[2][3]*b[3][3];

	// fourth row
	res[3][0]=a[3][0]*b[0][0]+a[3][1]*b[1][0]+a[3][2]*b[2][0]+a[3][3]*b[3][0];
	res[3][1]=a[3][0]*b[0][1]+a[3][1]*b[1][1]+a[3][2]*b[2][1]+a[3][3]*b[3][1];
	res[3][2]=a[3][0]*b[0][2]+a[3][1]*b[1][2]+a[3][2]*b[2][2]+a[3][3]*b[3][2];
	res[3][3]=a[3][0]*b[0][3]+a[3][1]*b[1][3]+a[3][2]*b[2][3]+a[3][3]*b[3][3];

}

void
Mat1x4_Mul4x4(const matrix_1x4f a, const matrix_4x4f b, matrix_1x4f v)
{
	v[0] = a[0] * b[0][0] + a[1] * b[0][1] + a[2] * b[0][2] + a[3] * b[0][3];
	v[1] = a[0] * b[1][0] + a[1] * b[1][1] + a[2] * b[1][2] + a[3] * b[1][3];
	v[2] = a[0] * b[2][0] + a[1] * b[2][1] + a[2] * b[2][2] + a[3] * b[2][3];
	v[3] = a[0] * b[3][0] + a[1] * b[3][1] + a[2] * b[3][2] + a[3] * b[3][3];
}


#define ASPECT_RATIO 1

void
Y3DLine(pixel_buffer screenInfo, 
	const Point3Dhf pt1, const Point3Dhf pt2, 
	const U08 aColor, const Camera aCamera)
	
{
	float width = screenInfo.width;
	float height = screenInfo.height;
	
	float x1,y1,z1,     // working variables
		x2,y2,z2;
	int ix1,iy1,        // integers used to hold screen coordinates
		ix2,iy2;
	// convert to screen ccordinates
	x1=(width/2  + pt1.x*aCamera.viewing_distance/pt1.z);
	y1=(height/2 - ASPECT_RATIO*pt1.y*aCamera.viewing_distance/pt1.z);
	x2=(width/2  + pt2.x*aCamera.viewing_distance/pt2.z);
	y2=(height/2 - ASPECT_RATIO*pt2.y*aCamera.viewing_distance/pt2.z);
	
	// convert floats to integers for line clipper
	ix1=(long)x1;
	iy1=(long)y1;
	ix2=(long)x2;
	iy2=(long)y2;

	// draw clipped lines
	if (Y2DClipLine(0,0,width,height, &ix1,&iy1,&ix2,&iy2))
	{
		Y2DLine(screenInfo, (U16)ix1,(U16)iy1,(U16)ix2,(U16)iy2,
aColor);
	} // end if clip
}

void
Y3DRenderWireObject(pixel_buffer screenInfo,
	const FacetedObject3D *aObject,
	const U08 aColor, Camera *aCamera)
{
	// For each facet in the object
	for (int faceCtr=0; faceCtr < aObject->fNumFaces; faceCtr++)
	{
		// for each line in the facet
		for (int lineCtr=0; lineCtr < aObject->fFaces[faceCtr].fNumVertices-1; lineCtr++)
		{
			// draw the line
			Y3DLine(screenInfo,
				aObject->fFaces[faceCtr].fVertexList[lineCtr],
				aObject->fFaces[faceCtr].fVertexList[lineCtr+1],
				aObject->fFaces[faceCtr].fColor,
				*aCamera);
		}
		
		// draw the closing line
		Y3DLine(screenInfo,
			aObject->fFaces[faceCtr].fVertexList[aObject->fFaces[faceCtr].fNumVertices-1],
			aObject->fFaces[faceCtr].fVertexList[0],
			aObject->fFaces[faceCtr].fColor,
			*aCamera);
	}
}
