#include "yags2d.h"
#include <string.h>
#include <stdlib.h>

void
Y2DCopyPixels(pixel_buffer dst, const pixel_buffer src)
{
	unsigned long height = Y2DMIN(dst.height, src.height);
	unsigned long width= Y2DMIN(dst.width, src.width);
	unsigned long dstoffset = 0;
	unsigned long srcoffset = 0;
	U08 * dstbits = (U08 *)dst.pixels;
	U08 * srcbits = (U08 *)src.pixels;
	
	for (int y = 0; y < height; y++)
	{
		memcpy((U08 *)&dstbits[dstoffset],(U08 *)&srcbits[srcoffset],width);
		dstoffset += dst.bytes_per_row;
		srcoffset += src.bytes_per_row;
	}
}

void
Y2DCopyPixels(pixel_buffer dst, 
	const pixel_buffer src, 
	const U16 x1, const U16 y1)
{
	unsigned long height = Y2DMIN(dst.height, src.height);
	unsigned long width= Y2DMIN(dst.width, src.width);
	unsigned long dstoffset = y1*dst.bytes_per_row+x1;
	unsigned long srcoffset = 0;
	U08 * dstbits = (U08 *)dst.pixels;
	U08 * srcbits = (U08 *)src.pixels;
	
	for (int y = 0; y < height; y++)
	{
		memcpy((U08 *)&dstbits[dstoffset],(U08 *)&srcbits[srcoffset],width);
		dstoffset += dst.bytes_per_row;
		srcoffset += src.bytes_per_row;
	}
}


void
Y2DCopyPixels(pixel_buffer dst, 
	const pixel_buffer src, 
	const U16 top, const U16 left,
	const U16 right, const U16 bottom)
{
#if 0
	unsigned long height = Y2DMIN(dst.frame.Height(), src.frame.Height());
	unsigned long width= Y2DMIN(dst.frame.Width(), src.frame.Width());
	unsigned long dstoffset = y1*dst.bytes_per_row+x1;
	unsigned long srcoffset = 0;
	U08 * dstbits = (U08 *)dst.bits;
	U08 * srcbits = (U08 *)src.bits;
	
	for (int y = 0; y < height; y++)
	{
		memcpy((U08 *)&dstbits[dstoffset],(U08 *)&srcbits[srcoffset],width);
		dstoffset += dst.bytes_per_row;
		srcoffset += src.bytes_per_row;
	}
#endif
}

pixel_buffer *
Y2DCreatePixelBuffer(const U16 width, const U16 height)
{
	pixel_buffer * newBuffer = (pixel_buffer *)malloc(sizeof(pixel_buffer));
	
	newBuffer->mode = B_COLOR_8_BIT;
	newBuffer->width = width;
	newBuffer->height = height;
	newBuffer->pixels = malloc(width*height);
	newBuffer->bytes_per_row = width;
	
	return newBuffer;
}


void
Y2DDestroyPixelBuffer(pixel_buffer *aBuffer)
{
	//free(aBuffer->bits);
	free(aBuffer);
}
