#ifndef YAGSTST_H
#define YAGSTST_H

#include <stdlib.h>
#include "yags2d.h"
#include "yags3d.h"

typedef struct testParam 
{
	pixel_buffer fScreenInfo;
	BRect		fFrame;
} testParam;


void TestPoint(pixel_buffer scrInfo, const U16 left, const U16 top, const U16 width, const U16 height);
long TestPointThread(void *data);

void TestLine(pixel_buffer scrInfo,const U16 left, const U16 top, const U16 width, const U16 height);
long TestLineThread(void *data);

void TestLine3D(pixel_buffer scrInfo,const U16 left, const U16 top, const U16 width, const U16 height);
long TestLine3DThread(void *data);

void TestCircle(pixel_buffer scrInfo,const U16 left, const U16 top, const U16 width, const U16 height);
long TestCircleThread(void *data);

void TestEffects(pixel_buffer scrInfo,const U16 left, const U16 top, const U16 width, const U16 height);
long TestEffectsThread(void *data);

void TestEllipse(pixel_buffer scrInfo,const U16 left, const U16 top, const U16 width, const U16 height);
long TestEllipseThread(void *data);

void TestBitmap(pixel_buffer scrInfo,const U16 left, const U16 top, const U16 width, const U16 height);
long TestBitmapThread(void *data);

void TestRectangle(pixel_buffer scrInfo,const U16 left, const U16 top, const U16 width, const U16 height);
long TestRectangleThread(void *data);

void TestTriangle(pixel_buffer scrInfo,const U16 left, const U16 top, const U16 width, const U16 height);
long TestTriangleThread(void *data);

void TestQuad(pixel_buffer scrInfo,const U16 left, const U16 top, const U16 width, const U16 height);
long TestQuadThread(void *data);


#endif
